/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.naming;

import com.sun.net.ssl.HostnameVerifier;
import com.sun.net.ssl.HttpsURLConnection;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.ObjectFactory;
import org.jboss.invocation.MarshalledValue;
import org.jboss.invocation.http.interfaces.AnyhostVerifier;
import org.jboss.invocation.http.interfaces.Util;
import org.jboss.logging.Logger;
import org.jnp.interfaces.Naming;
import org.jnp.interfaces.NamingContext;

public class HttpNamingContextFactory
implements InitialContextFactory,
ObjectFactory {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$naming$HttpNamingContextFactory == null ? (class$org$jboss$naming$HttpNamingContextFactory = HttpNamingContextFactory.class$("org.jboss.naming.HttpNamingContextFactory")) : class$org$jboss$naming$HttpNamingContextFactory));
    static /* synthetic */ Class class$org$jboss$naming$HttpNamingContextFactory;

    public Context getInitialContext(Hashtable env) throws NamingException {
        String provider = (String)env.get("java.naming.provider.url");
        if (provider.startsWith("jnp:")) {
            provider = "http:" + provider.substring(4);
        } else if (provider.startsWith("jnps:")) {
            provider = "https:" + provider.substring(5);
        } else if (provider.startsWith("jnp-http:")) {
            provider = "http:" + provider.substring(9);
        } else if (provider.startsWith("jnp-https:")) {
            provider = "https:" + provider.substring(10);
        }
        URL providerURL = null;
        Naming namingServer = null;
        try {
            providerURL = new URL(provider);
            namingServer = this.getNamingServer(providerURL);
        }
        catch (Exception e) {
            NamingException ex = new NamingException("Failed to retrieve Naming interface");
            ex.setRootCause(e);
            throw ex;
        }
        env = (Hashtable)env.clone();
        return new NamingContext(env, null, namingServer);
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable env) throws Exception {
        Context ctx = this.getInitialContext(env);
        Reference ref = (Reference)obj;
        RefAddr addr = ref.get("URL");
        String path = (String)addr.getContent();
        return ctx.lookup(path);
    }

    private Naming getNamingServer(URL providerURL) throws ClassNotFoundException, IOException {
        Util.init();
        log.debug((Object)("Retrieving content from : " + providerURL));
        HttpURLConnection conn = (HttpURLConnection)providerURL.openConnection();
        if (conn instanceof HttpsURLConnection && Boolean.getBoolean("org.jboss.security.ignoreHttpsHost")) {
            HttpsURLConnection sconn = (HttpsURLConnection)conn;
            AnyhostVerifier verifier = new AnyhostVerifier();
            sconn.setHostnameVerifier((HostnameVerifier)verifier);
        }
        int length = conn.getContentLength();
        String type = conn.getContentType();
        log.debug((Object)("ContentLength: " + length + "\nContentType: " + type));
        InputStream is = conn.getInputStream();
        ObjectInputStream ois = new ObjectInputStream(is);
        MarshalledValue mv = (MarshalledValue)ois.readObject();
        ois.close();
        Naming namingServer = (Naming)mv.get();
        return namingServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

