/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy.compiler;

import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.CompoundInstruction;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;
import org.jboss.proxy.compiler.Utility;

public class ProxyImplementationFactory {
    private static final String RUNTIME_CN = (class$org$jboss$proxy$compiler$Runtime == null ? (class$org$jboss$proxy$compiler$Runtime = ProxyImplementationFactory.class$("org.jboss.proxy.compiler.Runtime")) : class$org$jboss$proxy$compiler$Runtime).getName();
    private static final String INVOCATION_HANDLER_CN = (class$org$jboss$proxy$compiler$InvocationHandler == null ? (class$org$jboss$proxy$compiler$InvocationHandler = ProxyImplementationFactory.class$("org.jboss.proxy.compiler.InvocationHandler")) : class$org$jboss$proxy$compiler$InvocationHandler).getName();
    private static final String STRING_BUFFER_CN = (class$java$lang$StringBuffer == null ? (class$java$lang$StringBuffer = ProxyImplementationFactory.class$("java.lang.StringBuffer")) : class$java$lang$StringBuffer).getName();
    private static final ObjectType RUNTIME_T = (ObjectType)Utility.getType(class$org$jboss$proxy$compiler$Runtime == null ? (class$org$jboss$proxy$compiler$Runtime = ProxyImplementationFactory.class$("org.jboss.proxy.compiler.Runtime")) : class$org$jboss$proxy$compiler$Runtime);
    private static final ObjectType INVOCATION_HANDLER_T = (ObjectType)Utility.getType(class$org$jboss$proxy$compiler$InvocationHandler == null ? (class$org$jboss$proxy$compiler$InvocationHandler = ProxyImplementationFactory.class$("org.jboss.proxy.compiler.InvocationHandler")) : class$org$jboss$proxy$compiler$InvocationHandler);
    private static final ArrayType ARRAY_OF_CLASS_T = new ArrayType("java.lang.Class", 1);
    private static final ObjectType OBJECT_T = new ObjectType("java.lang.Object");
    private static final ArrayType ARRAY_OF_OBJECT_T = new ArrayType("java.lang.Object", 1);
    private static final ObjectType STRING_T = new ObjectType("java.lang.String");
    private static final ObjectType STRING_BUFFER_T = new ObjectType("java.lang.StringBuffer");
    private static final ObjectType PROXY_TARGET_T = new ObjectType((class$org$jboss$proxy$compiler$Proxies$ProxyTarget == null ? (class$org$jboss$proxy$compiler$Proxies$ProxyTarget = ProxyImplementationFactory.class$("org.jboss.proxy.compiler.Proxies$ProxyTarget")) : class$org$jboss$proxy$compiler$Proxies$ProxyTarget).getName());
    private static final Type[] INVOKE_ARGS = new Type[]{INVOCATION_HANDLER_T, Type.INT, ARRAY_OF_OBJECT_T};
    private static final String GET_INVOCATION_HANDLER_MN = "getInvocationHandler";
    private static final String GET_TARGET_TYPES_MN = "getTargetTypes";
    private static final String TO_STRING_MN = "toString";
    private static final String APPEND_MN = "append";
    private static final String CTOR_MN = "<init>";
    private static final String INVOCATION_HANDLER_FN = "invocationHandler";
    private static Type PROXY_CLASS_T;
    private InstructionList il = new InstructionList();
    private String proxyClassName;
    private String superClassName;
    private ConstantPoolGen constPool;
    private InstructionFactory iFactory;
    static /* synthetic */ Class class$org$jboss$proxy$compiler$Runtime;
    static /* synthetic */ Class class$org$jboss$proxy$compiler$InvocationHandler;
    static /* synthetic */ Class class$java$lang$StringBuffer;
    static /* synthetic */ Class class$org$jboss$proxy$compiler$Proxies$ProxyTarget;

    public ProxyImplementationFactory(String superClassName, String proxyClassName, ClassGen cg) {
        this.superClassName = superClassName;
        this.proxyClassName = proxyClassName;
        PROXY_CLASS_T = new ObjectType(proxyClassName);
        this.constPool = cg.getConstantPool();
        this.iFactory = new InstructionFactory(cg, this.constPool);
    }

    public Method createGetInvocationHandler() {
        MethodGen mg = new MethodGen(1, (Type)INVOCATION_HANDLER_T, Type.NO_ARGS, null, GET_INVOCATION_HANDLER_MN, this.proxyClassName, this.il, this.constPool);
        this.il.append((Instruction)InstructionFactory.createLoad((Type)PROXY_CLASS_T, (int)0));
        this.il.append((Instruction)this.iFactory.createGetField(this.proxyClassName, INVOCATION_HANDLER_FN, (Type)INVOCATION_HANDLER_T));
        this.il.append((Instruction)InstructionFactory.createReturn((Type)INVOCATION_HANDLER_T));
        mg.stripAttributes(true);
        mg.setMaxStack();
        mg.setMaxLocals();
        return this.getMethodAndTidyup(mg);
    }

    public Method createGetTargetTypes() {
        MethodGen mg = new MethodGen(1, (Type)ARRAY_OF_CLASS_T, Type.NO_ARGS, null, GET_TARGET_TYPES_MN, this.proxyClassName, this.il, this.constPool);
        this.il.append((Instruction)InstructionFactory.createLoad((Type)PROXY_CLASS_T, (int)0));
        this.il.append((Instruction)this.iFactory.createGetField(this.proxyClassName, "runtime", (Type)RUNTIME_T));
        this.il.append((Instruction)this.iFactory.createInvoke(RUNTIME_CN, "copyTargetTypes", (Type)ARRAY_OF_CLASS_T, Type.NO_ARGS, (short)182));
        this.il.append((Instruction)InstructionFactory.createReturn((Type)ARRAY_OF_CLASS_T));
        mg.stripAttributes(true);
        mg.setMaxStack(1);
        mg.setMaxLocals();
        return this.getMethodAndTidyup(mg);
    }

    public Method createToString() {
        MethodGen mg = new MethodGen(1, (Type)STRING_T, Type.NO_ARGS, null, TO_STRING_MN, this.proxyClassName, this.il, this.constPool);
        this.il.append((Instruction)this.iFactory.createNew(STRING_BUFFER_T));
        this.il.append((Instruction)InstructionFactory.createDup((int)1));
        this.il.append((Instruction)this.iFactory.createInvoke(STRING_BUFFER_CN, CTOR_MN, (Type)Type.VOID, Type.NO_ARGS, (short)183));
        this.il.append((CompoundInstruction)new PUSH(this.constPool, "ProxyTarget["));
        this.il.append((Instruction)this.iFactory.createInvoke(STRING_BUFFER_CN, APPEND_MN, (Type)STRING_BUFFER_T, new Type[]{STRING_T}, (short)182));
        this.il.append((Instruction)InstructionFactory.createLoad((Type)PROXY_CLASS_T, (int)0));
        this.il.append((Instruction)this.iFactory.createGetField(this.proxyClassName, INVOCATION_HANDLER_FN, (Type)INVOCATION_HANDLER_T));
        this.il.append((Instruction)this.iFactory.createInvoke(STRING_BUFFER_CN, APPEND_MN, (Type)STRING_BUFFER_T, new Type[]{OBJECT_T}, (short)182));
        this.il.append((CompoundInstruction)new PUSH(this.constPool, "]"));
        this.il.append((Instruction)this.iFactory.createInvoke(STRING_BUFFER_CN, APPEND_MN, (Type)STRING_BUFFER_T, new Type[]{STRING_T}, (short)182));
        this.il.append((Instruction)this.iFactory.createInvoke(STRING_BUFFER_CN, TO_STRING_MN, (Type)STRING_T, Type.NO_ARGS, (short)182));
        this.il.append((Instruction)InstructionFactory.createReturn((Type)STRING_T));
        mg.stripAttributes(true);
        mg.setMaxStack();
        mg.setMaxLocals();
        return this.getMethodAndTidyup(mg);
    }

    public Method createConstructor() {
        MethodGen mg = new MethodGen(1, (Type)Type.VOID, new Type[]{INVOCATION_HANDLER_T}, null, CTOR_MN, this.proxyClassName, this.il, this.constPool);
        this.il.append((Instruction)InstructionFactory.createLoad((Type)INVOCATION_HANDLER_T, (int)0));
        this.il.append((Instruction)this.iFactory.createInvoke(this.superClassName, CTOR_MN, (Type)Type.VOID, Type.NO_ARGS, (short)183));
        this.il.append((Instruction)InstructionFactory.createLoad((Type)PROXY_CLASS_T, (int)0));
        this.il.append((Instruction)InstructionFactory.createLoad((Type)INVOCATION_HANDLER_T, (int)1));
        this.il.append((Instruction)this.iFactory.createPutField(this.proxyClassName, INVOCATION_HANDLER_FN, (Type)INVOCATION_HANDLER_T));
        this.il.append((Instruction)InstructionFactory.createReturn((Type)Type.VOID));
        mg.stripAttributes(true);
        mg.setMaxStack();
        mg.setMaxLocals();
        return this.getMethodAndTidyup(mg);
    }

    public Method createProxyMethod(String name, int methodNum, Type rType, Type[] pTypes, String[] exceptionNames) {
        MethodGen mg = new MethodGen(1, rType, pTypes, null, name, this.proxyClassName, this.il, this.constPool);
        int j = 0;
        while (j < exceptionNames.length) {
            mg.addException(exceptionNames[j]);
            ++j;
        }
        this.il.append((Instruction)this.iFactory.createGetStatic(this.proxyClassName, "runtime", (Type)RUNTIME_T));
        this.il.append((Instruction)InstructionFactory.createLoad((Type)RUNTIME_T, (int)0));
        this.il.append((Instruction)this.iFactory.createGetField(this.proxyClassName, INVOCATION_HANDLER_FN, (Type)INVOCATION_HANDLER_T));
        this.il.append((CompoundInstruction)new PUSH(this.constPool, methodNum));
        this.il.append((CompoundInstruction)new PUSH(this.constPool, pTypes.length));
        this.il.append((Instruction)this.iFactory.createNewArray((Type)OBJECT_T, (short)1));
        if (pTypes.length > 0) {
            int i = 1;
            int j2 = 0;
            while (j2 < pTypes.length) {
                Type t = pTypes[j2];
                this.il.append((Instruction)InstructionFactory.createDup((int)1));
                this.il.append((CompoundInstruction)new PUSH(this.constPool, j2));
                if (t instanceof BasicType) {
                    String wrappedClassName = Utility.getObjectEquivalentClassName((BasicType)t);
                    ObjectType wrappedType = new ObjectType(wrappedClassName);
                    this.il.append((Instruction)this.iFactory.createNew(wrappedType));
                    this.il.append((Instruction)InstructionFactory.createDup((int)1));
                    this.il.append((Instruction)InstructionFactory.createLoad((Type)t, (int)i));
                    this.il.append((Instruction)this.iFactory.createInvoke(wrappedClassName, CTOR_MN, (Type)Type.VOID, new Type[]{t}, (short)183));
                    switch (t.getType()) {
                        case 7: 
                        case 11: {
                            ++i;
                        }
                    }
                    t = wrappedType;
                } else {
                    this.il.append((Instruction)InstructionFactory.createLoad((Type)t, (int)i));
                }
                ++i;
                this.il.append((Instruction)InstructionFactory.createArrayStore((Type)t));
                ++j2;
            }
        }
        this.il.append((Instruction)this.iFactory.createInvoke(RUNTIME_CN, "invoke", (Type)Type.OBJECT, INVOKE_ARGS, (short)182));
        if (rType instanceof ReferenceType) {
            this.il.append((Instruction)this.iFactory.createCheckCast((ReferenceType)rType));
        } else if (rType instanceof BasicType) {
            if (rType == Type.VOID) {
                this.il.append((Instruction)InstructionFactory.createPop((int)1));
            } else {
                String wrappedClassName = Utility.getObjectEquivalentClassName((BasicType)rType);
                ObjectType wrappedType = new ObjectType(wrappedClassName);
                this.il.append((Instruction)this.iFactory.createCheckCast((ReferenceType)wrappedType));
                String methodName = Utility.signatureToString((String)rType.getSignature()) + "Value";
                this.il.append((Instruction)this.iFactory.createInvoke(wrappedClassName, methodName, rType, Type.NO_ARGS, (short)182));
            }
        }
        this.il.append((Instruction)InstructionFactory.createReturn((Type)rType));
        mg.stripAttributes(true);
        mg.setMaxStack();
        mg.setMaxLocals();
        return this.getMethodAndTidyup(mg);
    }

    public Field createInvocationHandlerField() {
        FieldGen fg = new FieldGen(2, (Type)INVOCATION_HANDLER_T, INVOCATION_HANDLER_FN, this.constPool);
        return fg.getField();
    }

    public Field createRuntimeField() {
        FieldGen fg = new FieldGen(9, (Type)RUNTIME_T, "runtime", this.constPool);
        return fg.getField();
    }

    private Method getMethodAndTidyup(MethodGen mg) {
        Method m = mg.getMethod();
        this.il.dispose();
        return m;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

