/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.client;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.LinkedList;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.UserTransaction;
import org.jboss.invocation.jrmp.interfaces.JRMPInvokerProxy;
import org.jboss.tm.TransactionPropagationContextFactory;
import org.jboss.tm.usertx.interfaces.UserTransactionSession;
import org.jboss.tm.usertx.interfaces.UserTransactionSessionFactory;

public class ClientUserTransaction
implements UserTransaction,
TransactionPropagationContextFactory,
Referenceable,
Serializable {
    private static ClientUserTransaction singleton = null;
    private UserTransactionSession session = null;
    private transient ThreadLocal threadInfo = new ThreadLocal();

    public static ClientUserTransaction getSingleton() {
        if (singleton == null) {
            singleton = new ClientUserTransaction();
        }
        return singleton;
    }

    private ClientUserTransaction() {
        JRMPInvokerProxy.setTPCFactory(this);
    }

    public void begin() throws NotSupportedException, SystemException {
        ThreadInfo info = this.getThreadInfo();
        try {
            Object tpc = this.getSession().begin(info.getTimeout());
            info.push(tpc);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            throw new SystemException(e.toString());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        ThreadInfo info = this.getThreadInfo();
        try {
            this.getSession().commit(info.getTpc());
            info.pop();
        }
        catch (RollbackException e) {
            info.pop();
            throw e;
        }
        catch (HeuristicMixedException e) {
            throw e;
        }
        catch (HeuristicRollbackException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            throw new SystemException(e.toString());
        }
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        ThreadInfo info = this.getThreadInfo();
        try {
            this.getSession().rollback(info.getTpc());
            info.pop();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            throw new SystemException(e.toString());
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        ThreadInfo info = this.getThreadInfo();
        try {
            this.getSession().setRollbackOnly(info.getTpc());
        }
        catch (SystemException e) {
            throw e;
        }
        catch (IllegalStateException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            throw new SystemException(e.toString());
        }
    }

    public int getStatus() throws SystemException {
        ThreadInfo info = this.getThreadInfo();
        Object tpc = info.getTpc();
        if (tpc == null) {
            return 6;
        }
        try {
            return this.getSession().getStatus(tpc);
        }
        catch (SystemException e) {
            throw e;
        }
        catch (RemoteException e) {
            this.destroySession();
            throw new SystemException(e.toString());
        }
        catch (Exception e) {
            throw new SystemException(e.toString());
        }
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.getThreadInfo().setTimeout(seconds);
    }

    public Object getTransactionPropagationContext() {
        return this.getThreadInfo().getTpc();
    }

    public Object getTransactionPropagationContext(Transaction tx) {
        throw new InternalError("Should not have been used.");
    }

    public Reference getReference() throws NamingException {
        Reference ref = new Reference("org.jboss.tm.usertx.client.ClientUserTransaction", "org.jboss.tm.usertx.client.ClientUserTransactionObjectFactory", null);
        return ref;
    }

    private synchronized void createSession() {
        if (this.session != null) {
            this.destroySession();
        }
        try {
            UserTransactionSessionFactory factory = (UserTransactionSessionFactory)new InitialContext().lookup("UserTransactionSessionFactory");
            this.session = factory.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("UT factory lookup failed: " + ex);
        }
    }

    private synchronized void destroySession() {
        if (this.session != null) {
            try {
                this.session.destroy();
            }
            catch (RemoteException ex) {
                // empty catch block
            }
            this.session = null;
        }
    }

    private synchronized UserTransactionSession getSession() {
        if (this.session == null) {
            this.createSession();
        }
        return this.session;
    }

    private ThreadInfo getThreadInfo() {
        ThreadInfo ret = (ThreadInfo)this.threadInfo.get();
        if (ret == null) {
            ret = new ThreadInfo();
            this.threadInfo.set(ret);
        }
        return ret;
    }

    private class ThreadInfo {
        private LinkedList tpcStack = new LinkedList();
        private int timeout = 0;

        private ThreadInfo() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void finalize() throws Throwable {
            try {
                while (!this.tpcStack.isEmpty()) {
                    Object tpc = this.getTpc();
                    this.pop();
                    try {
                        ClientUserTransaction.this.getSession().rollback(tpc);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
            super.finalize();
        }

        void push(Object tpc) {
            this.tpcStack.addLast(tpc);
        }

        void pop() {
            this.tpcStack.removeLast();
        }

        Object getTpc() {
            return this.tpcStack.isEmpty() ? null : this.tpcStack.getLast();
        }

        int getTimeout() {
            return this.timeout;
        }

        void setTimeout(int seconds) {
            this.timeout = seconds;
        }
    }
}

