/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.Transaction;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.PayloadKey;

public class Invocation {
    public static final String[] INVOKE_SIGNATURE = new String[]{"org.jboss.invocation.Invocation"};
    public Map transient_payload;
    public Map as_is_payload;
    public Map payload;
    public InvocationContext invocationContext;
    public Object[] args;
    public Object objectName;
    public Method method;
    public InvocationType invocationType;

    public Invocation() {
    }

    public Invocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) {
        this.setId(id);
        this.setMethod(m);
        this.setArguments(args);
        this.setTransaction(tx);
        this.setPrincipal(identity);
        this.setCredential(credential);
    }

    public void setValue(Object key, Object value) {
        this.setValue(key, value, PayloadKey.PAYLOAD);
    }

    public void setValue(Object key, Object value, PayloadKey type) {
        if (type == PayloadKey.TRANSIENT) {
            this.getTransientPayload().put(key, value);
        } else if (type == PayloadKey.AS_IS) {
            this.getAsIsPayload().put(key, value);
        } else if (type == PayloadKey.PAYLOAD) {
            this.getPayload().put(key, value);
        } else {
            throw new IllegalArgumentException("Unknown PayloadKey: " + type);
        }
    }

    public Object getValue(Object key) {
        Object rtn = this.getPayloadValue(key);
        if (rtn != null) {
            return rtn;
        }
        rtn = this.getAsIsValue(key);
        if (rtn != null) {
            return rtn;
        }
        rtn = this.getTransientValue(key);
        return rtn;
    }

    public Object getPayloadValue(Object key) {
        if (this.payload == null) {
            return null;
        }
        return this.payload.get(key);
    }

    public Object getTransientValue(Object key) {
        if (this.transient_payload == null) {
            return null;
        }
        return this.transient_payload.get(key);
    }

    public Object getAsIsValue(Object key) {
        if (this.as_is_payload == null) {
            return null;
        }
        return this.as_is_payload.get(key);
    }

    public void setTransaction(Transaction tx) {
        if (tx instanceof Serializable) {
            this.getAsIsPayload().put(InvocationKey.TRANSACTION, tx);
        } else {
            this.getTransientPayload().put(InvocationKey.TRANSACTION, tx);
        }
    }

    public Transaction getTransaction() {
        Transaction tx = (Transaction)this.getAsIsPayload().get(InvocationKey.TRANSACTION);
        if (tx == null) {
            tx = (Transaction)this.getTransientPayload().get(InvocationKey.TRANSACTION);
        }
        return tx;
    }

    public void setPrincipal(Principal principal) {
        this.getAsIsPayload().put(InvocationKey.PRINCIPAL, principal);
    }

    public Principal getPrincipal() {
        return (Principal)this.getAsIsPayload().get(InvocationKey.PRINCIPAL);
    }

    public void setCredential(Object credential) {
        this.getPayload().put(InvocationKey.CREDENTIAL, credential);
    }

    public Object getCredential() {
        return this.getPayloadValue(InvocationKey.CREDENTIAL);
    }

    public void setObjectName(Object objectName) {
        this.objectName = objectName;
    }

    public Object getObjectName() {
        return this.objectName;
    }

    public void setType(InvocationType type) {
        this.invocationType = type;
    }

    public InvocationType getType() {
        if (this.invocationType == null) {
            return InvocationType.LOCAL;
        }
        return this.invocationType;
    }

    public void setId(Object id) {
        this.getPayload().put(InvocationKey.CACHE_ID, id);
    }

    public Object getId() {
        return this.getPayloadValue(InvocationKey.CACHE_ID);
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setArguments(Object[] arguments) {
        this.args = arguments;
    }

    public Object[] getArguments() {
        return this.args;
    }

    public InvocationContext getInvocationContext() {
        return this.invocationContext;
    }

    public void setInvocationContext(InvocationContext ctx) {
        this.invocationContext = ctx;
    }

    public void setEnterpriseContext(Object ctx) {
        this.getTransientPayload().put(InvocationKey.ENTERPRISE_CONTEXT, ctx);
    }

    public Object getEnterpriseContext() {
        return this.getTransientPayload().get(InvocationKey.ENTERPRISE_CONTEXT);
    }

    public Map getTransientPayload() {
        if (this.transient_payload == null) {
            this.transient_payload = new HashMap();
        }
        return this.transient_payload;
    }

    public Map getAsIsPayload() {
        if (this.as_is_payload == null) {
            this.as_is_payload = new HashMap();
        }
        return this.as_is_payload;
    }

    public Map getPayload() {
        if (this.payload == null) {
            this.payload = new HashMap();
        }
        return this.payload;
    }
}

