/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.Invoker;
import org.jboss.proxy.Interceptor;
import org.jboss.util.id.GUID;

public class InvokerInterceptor
extends Interceptor
implements Externalizable {
    private static final long serialVersionUID = 2548120545997920357L;
    private GUID invokerID = Invoker.ID;
    protected Invoker remoteInvoker;
    protected static Invoker localInvoker;

    public static Invoker getLocal() {
        return localInvoker;
    }

    public static void setLocal(Invoker invoker) {
        localInvoker = invoker;
    }

    public boolean isLocal() {
        return this.invokerID.equals((Object)Invoker.ID);
    }

    public Object invoke(Invocation invocation) throws Exception {
        Object returnValue = null;
        InvocationContext ctx = invocation.getInvocationContext();
        if (this.isLocal()) {
            returnValue = localInvoker.invoke(invocation);
        } else {
            Invoker invoker = ctx.getInvoker();
            returnValue = invoker.invoke(invocation);
        }
        return returnValue;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.invokerID);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.invokerID = (GUID)in.readObject();
    }
}

