/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import javax.transaction.Transaction;
import org.jboss.invocation.Invocation;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.InvocationType;
import org.jboss.invocation.MarshalledValue;

public class MarshalledInvocation
extends Invocation
implements Externalizable {
    static final long serialVersionUID = -718723094688127810L;
    protected Object tpc;
    protected transient Map methodMap;
    protected transient long methodHash = 0L;
    protected transient MarshalledValue marshalledArgs = null;
    static Map hashMap = new WeakHashMap();

    public static Map getInterfaceHashes(Class intf) {
        Method[] methods = intf.getDeclaredMethods();
        HashMap<String, Long> map = new HashMap<String, Long>();
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            Class<?>[] parameterTypes = method.getParameterTypes();
            String methodDesc = method.getName() + "(";
            int j = 0;
            while (j < parameterTypes.length) {
                methodDesc = methodDesc + MarshalledInvocation.getTypeString(parameterTypes[j]);
                ++j;
            }
            methodDesc = methodDesc + ")" + MarshalledInvocation.getTypeString(method.getReturnType());
            try {
                long hash = 0L;
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream(512);
                MessageDigest messagedigest = MessageDigest.getInstance("SHA");
                DataOutputStream dataoutputstream = new DataOutputStream(new DigestOutputStream(bytearrayoutputstream, messagedigest));
                dataoutputstream.writeUTF(methodDesc);
                dataoutputstream.flush();
                byte[] abyte0 = messagedigest.digest();
                int j2 = 0;
                while (j2 < Math.min(8, abyte0.length)) {
                    hash += (long)(abyte0[j2] & 0xFF) << j2 * 8;
                    ++j2;
                }
                map.put(method.toString(), new Long(hash));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        return map;
    }

    static String getTypeString(Class cl) {
        if (cl == Byte.TYPE) {
            return "B";
        }
        if (cl == Character.TYPE) {
            return "C";
        }
        if (cl == Double.TYPE) {
            return "D";
        }
        if (cl == Float.TYPE) {
            return "F";
        }
        if (cl == Integer.TYPE) {
            return "I";
        }
        if (cl == Long.TYPE) {
            return "J";
        }
        if (cl == Short.TYPE) {
            return "S";
        }
        if (cl == Boolean.TYPE) {
            return "Z";
        }
        if (cl == Void.TYPE) {
            return "V";
        }
        if (cl.isArray()) {
            return "[" + MarshalledInvocation.getTypeString(cl.getComponentType());
        }
        return "L" + cl.getName().replace('.', '/') + ";";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long calculateHash(Method method) {
        Map methodHashes = (Map)hashMap.get(method.getDeclaringClass());
        if (methodHashes == null) {
            methodHashes = MarshalledInvocation.getInterfaceHashes(method.getDeclaringClass());
            Map map = hashMap;
            synchronized (map) {
                hashMap.put(method.getDeclaringClass(), methodHashes);
            }
        }
        Long hash = (Long)methodHashes.get(method.toString());
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeHashes(Class declaringClass) {
        Map map = hashMap;
        synchronized (map) {
            hashMap.remove(declaringClass);
        }
    }

    public MarshalledInvocation() {
    }

    public MarshalledInvocation(Invocation invocation) {
        this.payload = invocation.payload;
        this.as_is_payload = invocation.as_is_payload;
        this.method = invocation.getMethod();
        this.objectName = invocation.getObjectName();
        this.args = invocation.getArguments();
        this.invocationType = invocation.getType();
    }

    public MarshalledInvocation(Object id, Method m, Object[] args, Transaction tx, Principal identity, Object credential) {
        super(id, m, args, tx, identity, credential);
    }

    public Method getMethod() {
        if (this.method != null) {
            return this.method;
        }
        this.method = (Method)this.methodMap.get(new Long(this.methodHash));
        if (this.method == null) {
            throw new IllegalStateException("Failed to find method for hash:" + this.methodHash);
        }
        return this.method;
    }

    public void setMethodMap(Map methods) {
        this.methodMap = methods;
    }

    public void setTransactionPropagationContext(Object tpc) {
        this.tpc = tpc;
    }

    public Object getTransactionPropagationContext() {
        return this.tpc;
    }

    public Object getValue(Object key) {
        Object value;
        block2: {
            value = super.getValue(key);
            if (!(value instanceof MarshalledValue)) break block2;
            try {
                MarshalledValue mv = (MarshalledValue)value;
                value = mv.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return value;
    }

    public Object getPayloadValue(Object key) {
        Object value;
        block2: {
            value = this.getPayload().get(key);
            if (!(value instanceof MarshalledValue)) break block2;
            try {
                MarshalledValue mv = (MarshalledValue)value;
                value = mv.get();
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
        }
        return value;
    }

    public Object[] getArguments() {
        block2: {
            if (this.args != null) break block2;
            try {
                this.args = (Object[])this.marshalledArgs.get();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.args;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        Object currentKey;
        Iterator keys;
        this.getAsIsPayload().put(InvocationKey.TYPE, this.invocationType);
        out.writeObject(this.tpc);
        long methodHash = MarshalledInvocation.calculateHash(this.method);
        out.writeLong(methodHash);
        out.writeObject(this.objectName);
        out.writeObject(new MarshalledValue(this.args));
        if (this.payload == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.payload.size());
            keys = this.payload.keySet().iterator();
            while (keys.hasNext()) {
                currentKey = keys.next();
                out.writeObject(currentKey);
                out.writeObject(new MarshalledValue(this.payload.get(currentKey)));
            }
        }
        if (this.as_is_payload == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.as_is_payload.size());
            keys = this.as_is_payload.keySet().iterator();
            while (keys.hasNext()) {
                currentKey = keys.next();
                out.writeObject(currentKey);
                out.writeObject(this.as_is_payload.get(currentKey));
            }
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int as_is_payloadSize;
        this.tpc = in.readObject();
        this.methodHash = in.readLong();
        this.objectName = in.readObject();
        this.marshalledArgs = (MarshalledValue)in.readObject();
        int payloadSize = in.readInt();
        if (payloadSize > 0) {
            this.payload = new HashMap();
            int i = 0;
            while (i < payloadSize) {
                Object key = in.readObject();
                Object value = in.readObject();
                this.payload.put(key, value);
                ++i;
            }
        }
        if ((as_is_payloadSize = in.readInt()) > 0) {
            this.as_is_payload = new HashMap();
            int i = 0;
            while (i < as_is_payloadSize) {
                Object key = in.readObject();
                Object value = in.readObject();
                this.as_is_payload.put(key, value);
                ++i;
            }
        }
        this.invocationType = (InvocationType)this.getAsIsValue(InvocationKey.TYPE);
    }
}

