/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.management.ObjectName;
import org.jboss.invocation.InvocationContext;
import org.jboss.invocation.InvocationKey;
import org.jboss.invocation.Invoker;
import org.jboss.proxy.ClientContainer;
import org.jboss.proxy.Interceptor;
import org.jboss.system.Registry;
import org.jboss.util.NestedRuntimeException;

public class GenericProxyFactory {
    public Object createProxy(Object id, ObjectName targetName, Invoker invoker, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces) {
        InvocationContext context = new InvocationContext();
        Integer nameHash = new Integer(targetName.hashCode());
        context.setObjectName(nameHash);
        context.setCacheId(id);
        if (jndiName != null) {
            context.setValue(InvocationKey.JNDI_NAME, jndiName);
        }
        if (invoker == null) {
            throw new RuntimeException("Null invoker given for name: " + targetName);
        }
        context.setInvoker(invoker);
        if (proxyBindingName != null) {
            context.setInvokerProxyBinding(proxyBindingName);
        }
        ClientContainer client = new ClientContainer(context);
        try {
            this.loadInterceptorChain(interceptorClasses, client);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Failed to load interceptor chain", (Throwable)e);
        }
        return Proxy.newProxyInstance(loader, ifaces, (InvocationHandler)client);
    }

    public Object createProxy(Object id, ObjectName targetName, ObjectName invokerName, String jndiName, String proxyBindingName, ArrayList interceptorClasses, ClassLoader loader, Class[] ifaces) {
        Invoker invoker;
        InvocationContext context = new InvocationContext();
        Integer nameHash = new Integer(targetName.hashCode());
        context.setObjectName(nameHash);
        context.setCacheId(id);
        if (jndiName != null) {
            context.setValue(InvocationKey.JNDI_NAME, jndiName);
        }
        if ((invoker = (Invoker)Registry.lookup((Object)invokerName)) == null) {
            throw new RuntimeException("Failed to find invoker for name: " + invokerName);
        }
        context.setInvoker(invoker);
        if (proxyBindingName != null) {
            context.setInvokerProxyBinding(proxyBindingName);
        }
        ClientContainer client = new ClientContainer(context);
        try {
            this.loadInterceptorChain(interceptorClasses, client);
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Failed to load interceptor chain", (Throwable)e);
        }
        return Proxy.newProxyInstance(loader, ifaces, (InvocationHandler)client);
    }

    protected void loadInterceptorChain(ArrayList chain, ClientContainer client) throws Exception {
        Interceptor last = null;
        int i = 0;
        while (i < chain.size()) {
            Class clazz = (Class)chain.get(i);
            Interceptor interceptor = (Interceptor)clazz.newInstance();
            if (last == null) {
                last = interceptor;
                client.setNext(interceptor);
            } else {
                last.setNext(interceptor);
                last = interceptor;
            }
            ++i;
        }
    }
}

