/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.usertx.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;

public class ServerVMClientUserTransaction
implements UserTransaction {
    private static final ServerVMClientUserTransaction singleton = new ServerVMClientUserTransaction();
    private final TransactionManager tm;
    private final Collection listeners = new ArrayList();

    public static ServerVMClientUserTransaction getSingleton() {
        return singleton;
    }

    private ServerVMClientUserTransaction() {
        TransactionManager local = null;
        try {
            local = (TransactionManager)new InitialContext().lookup("java:/TransactionManager");
        }
        catch (NamingException ex) {
            // empty catch block
        }
        this.tm = local;
    }

    public ServerVMClientUserTransaction(TransactionManager tm) {
        this.tm = tm;
    }

    public void registerTxStartedListener(UserTransactionStartedListener txStartedListener) {
        this.listeners.add(txStartedListener);
    }

    public void unregisterTxStartedListener(UserTransactionStartedListener txStartedListener) {
        this.listeners.remove(txStartedListener);
    }

    public void begin() throws NotSupportedException, SystemException {
        this.tm.begin();
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((UserTransactionStartedListener)i.next()).userTransactionStarted();
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.tm.commit();
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        this.tm.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.tm.setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        return this.tm.getStatus();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.tm.setTransactionTimeout(seconds);
    }

    public static interface UserTransactionStartedListener
    extends EventListener {
        public void userTransactionStarted() throws SystemException;
    }
}

