/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jboss.logging.Logger;
import org.jboss.util.stream.Streams;

public final class Files {
    private static final Logger log = Logger.getLogger(class$org$jboss$util$file$Files == null ? (class$org$jboss$util$file$Files = Files.class$("org.jboss.util.file.Files")) : class$org$jboss$util$file$Files);
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    static /* synthetic */ Class class$org$jboss$util$file$Files;

    public static boolean delete(File dir) {
        boolean success = true;
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File f = files[i];
                if (f.isDirectory()) {
                    if (!Files.delete(f)) {
                        success = false;
                        log.debug("Failed to delete dir: " + f.getAbsolutePath());
                    }
                } else if (!f.delete()) {
                    success = false;
                    log.debug("Failed to delete file: " + f.getAbsolutePath());
                }
                ++i;
            }
        }
        if (!dir.delete()) {
            success = false;
            log.debug("Failed to delete dir: " + dir.getAbsolutePath());
        }
        return success;
    }

    public static boolean delete(String dirname) {
        return Files.delete(new File(dirname));
    }

    public static boolean deleteContaining(String filename) {
        File file = new File(filename);
        File containingDir = file.getParentFile();
        return Files.delete(containingDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static void copy(File source, File target, byte[] buff) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));
        try {
            int read;
            while ((read = in.read(buff)) != -1) {
                void var5_5;
                out.write(buff, 0, (int)var5_5);
            }
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Streams.flush(out);
            Streams.close(in);
            Streams.close(out);
            throw throwable;
        }
        Streams.flush(out);
        Streams.close(in);
        Streams.close(out);
    }

    public static void copy(File source, File target, int size) throws IOException {
        Files.copy(source, target, new byte[size]);
    }

    public static void copy(File source, File target) throws IOException {
        Files.copy(source, target, 8192);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

