/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.net.protocol.URLLister;

public class URLListerFactory {
    private static HashMap defaultClasses = new HashMap();
    private HashMap classes = (HashMap)defaultClasses.clone();

    public URLLister createURLLister(URL url) throws MalformedURLException {
        return this.createURLLister(url.getProtocol());
    }

    public URLLister createURLLister(String protocol) throws MalformedURLException {
        try {
            String className = (String)this.classes.get(protocol);
            if (className == null) {
                throw new MalformedURLException(new JBossStringBuilder().append("No lister class defined for protocol ").append(protocol).toString());
            }
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            return (URLLister)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new MalformedURLException(e.getMessage());
        }
        catch (InstantiationException e) {
            throw new MalformedURLException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    public void registerListener(String protocol, String className) {
        this.classes.put(protocol, className);
    }

    static {
        defaultClasses.put("file", "org.jboss.net.protocol.file.FileURLLister");
        defaultClasses.put("http", "org.jboss.net.protocol.http.DavURLLister");
        defaultClasses.put("https", "org.jboss.net.protocol.http.DavURLLister");
    }
}

