/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.threadpool;

import org.jboss.lang.JBossStringBuilder;
import org.jboss.logging.Logger;
import org.jboss.util.threadpool.TaskWrapper;

public class RunnableTaskWrapper
implements TaskWrapper {
    private static final Logger log = Logger.getLogger(Class.forName("org.jboss.util.threadpool.RunnableTaskWrapper"));
    private Runnable runnable;
    private boolean started;
    private Thread runThread;
    private long startTimeout;
    private long completionTimeout;

    public RunnableTaskWrapper(Runnable runnable) {
        this(runnable, 0L, 0L);
    }

    public RunnableTaskWrapper(Runnable runnable, long startTimeout, long completeTimeout) {
        if (runnable == null) {
            throw new IllegalArgumentException("Null runnable");
        }
        this.runnable = runnable;
        this.startTimeout = startTimeout;
        this.completionTimeout = completeTimeout;
    }

    public int getTaskWaitType() {
        return 0;
    }

    public int getTaskPriority() {
        return 5;
    }

    public long getTaskStartTimeout() {
        return this.startTimeout;
    }

    public long getTaskCompletionTimeout() {
        return this.completionTimeout;
    }

    public void acceptTask() {
    }

    public void rejectTask(RuntimeException t) {
        throw t;
    }

    public void stopTask() {
        boolean trace = log.isTraceEnabled();
        if (this.runThread != null && !this.runThread.isInterrupted()) {
            this.runThread.interrupt();
            if (trace) {
                log.trace((Object)new JBossStringBuilder().append("stopTask, interrupted thread=").append((Object)this.runThread).toString());
            }
        } else if (this.runThread != null) {
            this.runThread.stop();
            if (trace) {
                log.trace((Object)new JBossStringBuilder().append("stopTask, stopped thread=").append((Object)this.runThread).toString());
            }
        }
    }

    public void waitForTask() {
    }

    public boolean isComplete() {
        return this.started && this.runThread == null;
    }

    public void run() {
        boolean trace = log.isTraceEnabled();
        try {
            if (trace) {
                log.trace((Object)new JBossStringBuilder().append("Begin run, wrapper=").append((Object)this).toString());
            }
            this.runThread = Thread.currentThread();
            this.started = true;
            this.runnable.run();
            this.runThread = null;
            if (trace) {
                log.trace((Object)new JBossStringBuilder().append("End run, wrapper=").append((Object)this).toString());
            }
        }
        catch (Throwable t) {
            log.warn((Object)new JBossStringBuilder().append("Unhandled throwable for runnable: ").append((Object)this.runnable).toString(), t);
        }
    }
}

