/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.lang.constant.Constable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jboss.util.EmptyStringException;
import org.jboss.util.NestedRuntimeException;
import org.jboss.util.NullArgumentException;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.UnreachableStatementException;

public final class Classes {
    public static final String PACKAGE_SEPARATOR = ".";
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String DEFAULT_PACKAGE_NAME = "<default>";
    private static final Map PRIMITIVE_NAME_TYPE_MAP = new HashMap();
    private static final Class[] PRIMITIVE_WRAPPER_MAP;

    public static void displayClassInfo(Class clazz, StringBuffer results) {
        ClassLoader cl = clazz.getClassLoader();
        results.append("\n");
        results.append(clazz.getName());
        results.append("(");
        results.append(Integer.toHexString(clazz.hashCode()));
        results.append(").ClassLoader=");
        results.append(cl);
        ClassLoader parent = cl;
        while (parent != null) {
            results.append("\n..");
            results.append(parent);
            URL[] urls = Classes.getClassLoaderURLs(parent);
            int length = urls != null ? urls.length : 0;
            for (int u = 0; u < length; ++u) {
                results.append("\n....");
                results.append(urls[u]);
            }
            if (parent == null) continue;
            parent = parent.getParent();
        }
        CodeSource clazzCS = clazz.getProtectionDomain().getCodeSource();
        if (clazzCS != null) {
            results.append("\n++++CodeSource: ");
            results.append(clazzCS);
        } else {
            results.append("\n++++Null CodeSource");
        }
        results.append("\nImplemented Interfaces:");
        Class<?>[] ifaces = clazz.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            Class<?> iface = ifaces[i];
            results.append("\n++");
            results.append(iface);
            results.append("(");
            results.append(Integer.toHexString(iface.hashCode()));
            results.append(")");
            ClassLoader loader = ifaces[i].getClassLoader();
            results.append("\n++++ClassLoader: ");
            results.append(loader);
            ProtectionDomain pd = ifaces[i].getProtectionDomain();
            CodeSource cs = pd.getCodeSource();
            if (cs != null) {
                results.append("\n++++CodeSource: ");
                results.append(cs);
                continue;
            }
            results.append("\n++++Null CodeSource");
        }
    }

    public static URL[] getClassLoaderURLs(ClassLoader cl) {
        URL[] urls = new URL[]{};
        try {
            Method getCp;
            Class<?> returnType = urls.getClass();
            Class[] parameterTypes = new Class[]{};
            Class<?> clClass = cl.getClass();
            Method getURLs = clClass.getMethod("getURLs", parameterTypes);
            if (returnType.isAssignableFrom(getURLs.getReturnType())) {
                Object[] args = new Object[]{};
                urls = (URL[])getURLs.invoke((Object)cl, args);
            }
            if ((urls == null || urls.length == 0) && returnType.isAssignableFrom((getCp = clClass.getMethod("getClasspath", parameterTypes)).getReturnType())) {
                Object[] args = new Object[]{};
                urls = (URL[])getCp.invoke((Object)cl, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return urls;
    }

    public static String getDescription(Object object) {
        StringBuffer buffer = new StringBuffer();
        Classes.describe(buffer, object);
        return buffer.toString();
    }

    public static void describe(StringBuffer buffer, Object object) {
        if (object == null) {
            buffer.append("**null**");
        } else {
            Classes.describe(buffer, object.getClass());
        }
    }

    public static void describe(StringBuffer buffer, Class clazz) {
        if (clazz == null) {
            buffer.append("**null**");
        } else {
            buffer.append("{class=").append(clazz.getName());
            Class<?>[] intfs = clazz.getInterfaces();
            if (intfs.length > 0) {
                buffer.append(" intfs=");
                for (int i = 0; i < intfs.length; ++i) {
                    buffer.append(intfs[i].getName());
                    if (i >= intfs.length - 1) continue;
                    buffer.append(", ");
                }
            }
            buffer.append("}");
        }
    }

    public static String stripPackageName(String classname) {
        int idx = classname.lastIndexOf(PACKAGE_SEPARATOR);
        if (idx != -1) {
            return classname.substring(idx + 1, classname.length());
        }
        return classname;
    }

    public static String stripPackageName(Class type) {
        return Classes.stripPackageName(type.getName());
    }

    public static String getPackageName(String classname) {
        if (classname.length() == 0) {
            throw new EmptyStringException();
        }
        int index = classname.lastIndexOf(PACKAGE_SEPARATOR);
        if (index != -1) {
            return classname.substring(0, index);
        }
        return "";
    }

    public static String getPackageName(Class type) {
        return Classes.getPackageName(type.getName());
    }

    public static void forceLoad(Class type) {
        if (type == null) {
            throw new NullArgumentException("type");
        }
        if (type.isPrimitive()) {
            return;
        }
        String packageName = Classes.getPackageName(type);
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            return;
        }
        try {
            Method[] methods = type.getDeclaredMethods();
            Method method = null;
            for (int i = 0; i < methods.length; ++i) {
                int modifiers = methods[i].getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                method = methods[i];
                break;
            }
            if (method != null) {
                method.invoke(null, null);
            } else {
                type.newInstance();
            }
        }
        catch (Exception ignore) {
            ThrowableHandler.add(ignore);
        }
    }

    public static Class getPrimitiveTypeForName(String name) {
        return (Class)PRIMITIVE_NAME_TYPE_MAP.get(name);
    }

    public static Class getPrimitiveWrapper(Class type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("type is not a primitive class");
        }
        for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2) {
            if (!type.equals(PRIMITIVE_WRAPPER_MAP[i])) continue;
            return PRIMITIVE_WRAPPER_MAP[i + 1];
        }
        throw new UnreachableStatementException();
    }

    public static void getAllInterfaces(List allIfaces, Class c) {
        while (c != null) {
            Class<?>[] ifaces = c.getInterfaces();
            for (int n = 0; n < ifaces.length; ++n) {
                allIfaces.add(ifaces[n]);
            }
            c = c.getSuperclass();
        }
    }

    public static boolean isPrimitiveWrapper(Class type) {
        for (int i = 0; i < PRIMITIVE_WRAPPER_MAP.length; i += 2) {
            if (!type.equals(PRIMITIVE_WRAPPER_MAP[i + 1])) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitive(Class type) {
        return type.isPrimitive() || Classes.isPrimitiveWrapper(type);
    }

    public static boolean isPrimitive(String type) {
        return PRIMITIVE_NAME_TYPE_MAP.containsKey(type);
    }

    public static Class getPrimitive(Class wrapper) {
        Class<Constable> primitive;
        if (Integer.class == wrapper) {
            primitive = Integer.TYPE;
        } else if (Long.class == wrapper) {
            primitive = Long.TYPE;
        } else if (Double.class == wrapper) {
            primitive = Double.TYPE;
        } else if (Boolean.class == wrapper) {
            primitive = Boolean.TYPE;
        } else if (Short.class == wrapper) {
            primitive = Short.TYPE;
        } else if (Float.class == wrapper) {
            primitive = Float.TYPE;
        } else if (Byte.class == wrapper) {
            primitive = Byte.TYPE;
        } else if (Character.class == wrapper) {
            primitive = Character.TYPE;
        } else {
            throw new IllegalArgumentException("The class is not a primitive wrapper type: " + wrapper);
        }
        return primitive;
    }

    public static Object instantiate(Class expected, String property, String defaultClassName) {
        String className = Classes.getProperty(property, defaultClassName);
        Class clazz = null;
        try {
            clazz = Classes.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new NestedRuntimeException("Cannot load class " + className, e);
        }
        Object result = null;
        try {
            result = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new NestedRuntimeException("Error instantiating " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new NestedRuntimeException("Error instantiating " + className, e);
        }
        if (!expected.isAssignableFrom(clazz)) {
            throw new NestedRuntimeException("Class " + className + " from classloader " + clazz.getClassLoader() + " is not of the expected class " + expected + " loaded from " + expected.getClassLoader());
        }
        return result;
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return Classes.loadClass(className, Thread.currentThread().getContextClassLoader());
    }

    public static Class loadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (className.length() == 1) {
            char type = className.charAt(0);
            if (type == 'B') {
                return Byte.TYPE;
            }
            if (type == 'C') {
                return Character.TYPE;
            }
            if (type == 'D') {
                return Double.TYPE;
            }
            if (type == 'F') {
                return Float.TYPE;
            }
            if (type == 'I') {
                return Integer.TYPE;
            }
            if (type == 'J') {
                return Long.TYPE;
            }
            if (type == 'S') {
                return Short.TYPE;
            }
            if (type == 'Z') {
                return Boolean.TYPE;
            }
            if (type == 'V') {
                return Void.TYPE;
            }
            throw new ClassNotFoundException(className);
        }
        if (Classes.isPrimitive(className)) {
            return (Class)PRIMITIVE_NAME_TYPE_MAP.get(className);
        }
        if (className.charAt(0) == 'L' && className.charAt(className.length() - 1) == ';') {
            return classLoader.loadClass(className.substring(1, className.length() - 1));
        }
        try {
            return classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (className.charAt(0) != '[') {
                throw e;
            }
            int arrayDimension = 0;
            while (className.charAt(arrayDimension) == '[') {
                ++arrayDimension;
            }
            Class componentType = Classes.loadClass(className.substring(arrayDimension), classLoader);
            return Array.newInstance(componentType, new int[arrayDimension]).getClass();
        }
    }

    public static final Class[] convertToJavaClasses(Iterator it, ClassLoader cl) throws ClassNotFoundException {
        ArrayList<Class> classes = new ArrayList<Class>();
        while (it.hasNext()) {
            classes.add(Classes.convertToJavaClass((String)it.next(), cl));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static final Method getAttributeGetter(Class cls, String attr) throws NoSuchMethodException {
        StringBuffer buf = new StringBuffer(attr.length() + 3);
        buf.append("get");
        if (Character.isLowerCase(attr.charAt(0))) {
            buf.append(Character.toUpperCase(attr.charAt(0))).append(attr.substring(1));
        } else {
            buf.append(attr);
        }
        try {
            return cls.getMethod(buf.toString(), null);
        }
        catch (NoSuchMethodException e) {
            buf.replace(0, 3, "is");
            return cls.getMethod(buf.toString(), null);
        }
    }

    public static final Method getAttributeSetter(Class cls, String attr, Class type) throws NoSuchMethodException {
        StringBuffer buf = new StringBuffer(attr.length() + 3);
        buf.append("set");
        if (Character.isLowerCase(attr.charAt(0))) {
            buf.append(Character.toUpperCase(attr.charAt(0))).append(attr.substring(1));
        } else {
            buf.append(attr);
        }
        return cls.getMethod(buf.toString(), type);
    }

    private static final Class convertToJavaClass(String name, ClassLoader cl) throws ClassNotFoundException {
        int arraySize = 0;
        while (name.endsWith("[]")) {
            name = name.substring(0, name.length() - 2);
            ++arraySize;
        }
        Class<?> c = (Class<?>)PRIMITIVE_NAME_TYPE_MAP.get(name);
        if (c == null) {
            try {
                c = cl.loadClass(name);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ClassNotFoundException("Parameter class not found: " + name);
            }
        }
        if (arraySize > 0) {
            int[] dims = new int[arraySize];
            for (int i = 0; i < arraySize; ++i) {
                dims[i] = 1;
            }
            c = Array.newInstance(c, dims).getClass();
        }
        return c;
    }

    private static String getProperty(final String name, final String defaultValue) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(name, defaultValue);
            }
        });
    }

    static {
        PRIMITIVE_NAME_TYPE_MAP.put("boolean", Boolean.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("byte", Byte.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("char", Character.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("short", Short.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("int", Integer.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("long", Long.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("float", Float.TYPE);
        PRIMITIVE_NAME_TYPE_MAP.put("double", Double.TYPE);
        PRIMITIVE_WRAPPER_MAP = new Class[]{Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Double.TYPE, Double.class, Float.TYPE, Float.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Short.TYPE, Short.class};
    }
}

