/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import org.jboss.logging.Logger;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.BaseWrapperManagedConnectionFactory;
import org.jboss.resource.adapter.jdbc.CachedPreparedStatement;
import org.jboss.resource.adapter.jdbc.PreparedStatementCache;
import org.jboss.resource.adapter.jdbc.WrappedConnection;

public abstract class BaseWrapperManagedConnection
implements ManagedConnection {
    protected final BaseWrapperManagedConnectionFactory mcf;
    protected final Connection con;
    protected final Properties props;
    private final int transactionIsolation;
    private final boolean readOnly;
    private final Collection cels = new ArrayList();
    private final Set handles = new HashSet();
    private PreparedStatementCache psCache = null;
    protected boolean inManagedTransaction = false;
    protected boolean jdbcAutoCommit = true;
    protected boolean underlyingAutoCommit = true;
    protected boolean jdbcReadOnly;
    protected boolean underlyingReadOnly;
    protected int jdbcTransactionIsolation;
    protected int underlyingTransactionIsolation;
    protected boolean destroyed = false;
    protected boolean setQueryTimeout = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseWrapperManagedConnection(BaseWrapperManagedConnectionFactory mcf, Connection con, Properties props, int transactionIsolation, int psCacheSize, boolean qTimeout) throws SQLException {
        this.mcf = mcf;
        this.con = con;
        this.props = props;
        this.setQueryTimeout = qTimeout;
        if (psCacheSize > 0) {
            this.psCache = new PreparedStatementCache(psCacheSize);
        }
        if (transactionIsolation == -1) {
            this.transactionIsolation = con.getTransactionIsolation();
        } else {
            this.transactionIsolation = transactionIsolation;
            con.setTransactionIsolation(transactionIsolation);
        }
        this.readOnly = con.isReadOnly();
        if (mcf.getNewConnectionSQL() != null) {
            Statement s = con.createStatement();
            try {
                s.execute(mcf.getNewConnectionSQL());
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                s.close();
                throw throwable;
            }
            s.close();
            {
            }
        }
        this.underlyingReadOnly = this.readOnly;
        this.jdbcReadOnly = this.readOnly;
        this.underlyingTransactionIsolation = this.transactionIsolation;
        this.jdbcTransactionIsolation = this.transactionIsolation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionEventListener(ConnectionEventListener cel) {
        Collection collection = this.cels;
        synchronized (collection) {
            this.cels.add(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionEventListener(ConnectionEventListener cel) {
        Collection collection = this.cels;
        synchronized (collection) {
            this.cels.remove(cel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void associateConnection(Object handle) throws ResourceException {
        if (!(handle instanceof WrappedConnection)) {
            throw new JBossResourceException("Wrong kind of connection handle to associate" + handle);
        }
        ((WrappedConnection)handle).setManagedConnection(this);
        Set set = this.handles;
        synchronized (set) {
            this.handles.add(handle);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return null;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        return null;
    }

    public void setLogWriter(PrintWriter param1) throws ResourceException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() throws ResourceException {
        Set set = this.handles;
        synchronized (set) {
            Iterator i = this.handles.iterator();
            while (i.hasNext()) {
                WrappedConnection lc = (WrappedConnection)i.next();
                lc.setManagedConnection(null);
            }
            this.handles.clear();
        }
        this.jdbcAutoCommit = true;
        this.jdbcTransactionIsolation = this.transactionIsolation;
        this.jdbcReadOnly = this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        this.checkIdentity(subject, cri);
        WrappedConnection lc = new WrappedConnection(this, this.setQueryTimeout);
        Set set = this.handles;
        synchronized (set) {
            this.handles.add(lc);
        }
        return lc;
    }

    public void destroy() throws ResourceException {
        this.destroyed = true;
        this.cleanup();
        if (this.psCache != null) {
            this.psCache.flush();
        }
        try {
            this.con.close();
        }
        catch (SQLException e) {
            this.checkException(e);
        }
    }

    public boolean checkValid() {
        SQLException e = this.mcf.isValidConnection(this.con);
        if (e == null) {
            return true;
        }
        this.mcf.log.warn((Object)"Destroying connection that is not valid, due to the following exception:", (Throwable)e);
        this.broadcastConnectionError(e);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeHandle(WrappedConnection handle) {
        if (this.destroyed) {
            return;
        }
        Set set = this.handles;
        synchronized (set) {
            this.handles.remove(handle);
        }
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 1);
        ce.setConnectionHandle((Object)handle);
        ArrayList copy = null;
        Collection collection = this.cels;
        synchronized (collection) {
            copy = new ArrayList(this.cels);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            ConnectionEventListener cel = (ConnectionEventListener)i.next();
            cel.connectionClosed(ce);
        }
    }

    void connectionError(SQLException e) {
        if (this.mcf.isExceptionFatal(e)) {
            this.broadcastConnectionError(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void broadcastConnectionError(SQLException e) {
        ConnectionEvent ce = new ConnectionEvent((ManagedConnection)this, 5, (Exception)e);
        ArrayList copy = null;
        Collection collection = this.cels;
        synchronized (collection) {
            copy = new ArrayList(this.cels);
        }
        Iterator i = copy.iterator();
        while (i.hasNext()) {
            ConnectionEventListener cel = (ConnectionEventListener)i.next();
            cel.connectionErrorOccurred(ce);
        }
    }

    Connection getConnection() throws SQLException {
        if (this.con == null) {
            throw new SQLException("Connection has been destroyed!!!");
        }
        return this.con;
    }

    PreparedStatement prepareStatement(String sql) throws SQLException {
        if (this.psCache != null) {
            CachedPreparedStatement cachedps = (CachedPreparedStatement)this.psCache.get(sql);
            if (cachedps == null) {
                PreparedStatement ps = this.con.prepareStatement(sql);
                cachedps = new CachedPreparedStatement(ps);
                this.psCache.insert(sql, cachedps);
            }
            return cachedps;
        }
        return this.con.prepareStatement(sql);
    }

    protected Logger getLog() {
        return this.mcf.log;
    }

    private void checkIdentity(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties newProps = this.mcf.getConnectionProperties(subject, cri);
        if (!this.props.equals(newProps)) {
            throw new JBossResourceException("Wrong credentials passed to getConnection!");
        }
    }

    void checkTransaction() throws SQLException {
        if (this.inManagedTransaction) {
            return;
        }
        if (this.jdbcAutoCommit != this.underlyingAutoCommit) {
            this.con.setAutoCommit(this.jdbcAutoCommit);
            this.underlyingAutoCommit = this.jdbcAutoCommit;
        }
        this.checkState();
    }

    protected void checkState() throws SQLException {
        if (this.jdbcTransactionIsolation != this.underlyingTransactionIsolation) {
            this.con.setTransactionIsolation(this.jdbcTransactionIsolation);
            this.underlyingTransactionIsolation = this.jdbcTransactionIsolation;
        }
        if (this.jdbcReadOnly != this.underlyingReadOnly) {
            this.con.setReadOnly(this.jdbcReadOnly);
            this.underlyingReadOnly = this.jdbcReadOnly;
        }
    }

    boolean isJdbcAutoCommit() {
        return this.inManagedTransaction ? false : this.jdbcAutoCommit;
    }

    void setJdbcAutoCommit(boolean jdbcAutoCommit) throws SQLException {
        if (this.inManagedTransaction) {
            throw new SQLException("You cannot set autocommit during a managed transaction!");
        }
        this.jdbcAutoCommit = jdbcAutoCommit;
    }

    boolean isJdbcReadOnly() {
        return this.jdbcReadOnly;
    }

    void setJdbcReadOnly(boolean readOnly) throws SQLException {
        if (this.inManagedTransaction) {
            throw new SQLException("You cannot set read only during a managed transaction!");
        }
        this.jdbcReadOnly = readOnly;
    }

    int getJdbcTransactionIsolation() {
        return this.jdbcTransactionIsolation;
    }

    void setJdbcTransactionIsolation(int isolationLevel) throws SQLException {
        if (this.inManagedTransaction) {
            throw new SQLException("You cannot set isolation level during a managed transaction!");
        }
        this.jdbcTransactionIsolation = isolationLevel;
    }

    void jdbcCommit() throws SQLException {
        if (this.inManagedTransaction) {
            throw new SQLException("You cannot commit during a managed transaction!");
        }
        if (this.jdbcAutoCommit) {
            throw new SQLException("You cannot commit with autocommit set!");
        }
        this.con.commit();
    }

    void jdbcRollback() throws SQLException {
        if (this.inManagedTransaction) {
            throw new SQLException("You cannot rollback during a managed transaction!");
        }
        if (this.jdbcAutoCommit) {
            throw new SQLException("You cannot rollback with autocommit set!");
        }
        this.con.rollback();
    }

    void jdbcRollback(Savepoint savepoint) throws SQLException {
        if (this.inManagedTransaction) {
            throw new SQLException("You cannot rollback during a managed transaction!");
        }
        if (this.jdbcAutoCommit) {
            throw new SQLException("You cannot rollback with autocommit set!");
        }
        this.con.rollback(savepoint);
    }

    boolean getTrackStatements() {
        return this.mcf.getTrackStatements();
    }

    protected void checkException(SQLException e) throws ResourceException {
        this.connectionError(e);
        throw new JBossResourceException("SQLException", (Throwable)e);
    }
}

