/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logging.util;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.log4j.Category;
import org.apache.log4j.Priority;

public class CategoryStream
extends PrintStream {
    private Category category;
    private Priority priority;
    private boolean inWrite;
    private boolean issuedWarning;

    public CategoryStream(Category category) {
        this(category, Priority.INFO, System.out);
    }

    public CategoryStream(Category category, Priority priority, PrintStream ps) {
        super(ps);
        this.category = category;
        this.priority = priority;
    }

    public void println(String msg) {
        if (msg == null) {
            msg = "null";
        }
        byte[] bytes = msg.getBytes();
        this.write(bytes, 0, bytes.length);
    }

    public void println(Object msg) {
        if (msg == null) {
            msg = "null";
        }
        byte[] bytes = msg.toString().getBytes();
        this.write(bytes, 0, bytes.length);
    }

    public void write(byte b) {
        byte[] bytes = new byte[]{b};
        this.write(bytes, 0, 1);
    }

    public synchronized void write(byte[] b, int off, int len) {
        if (this.inWrite) {
            if (!this.issuedWarning) {
                String msg = "ERROR: invalid console appender config detected, console stream is looping";
                try {
                    this.out.write(msg.getBytes());
                }
                catch (IOException ignore) {
                    // empty catch block
                }
                this.issuedWarning = true;
            }
            return;
        }
        this.inWrite = true;
        while (len > 0 && (b[len - 1] == 10 || b[len - 1] == 13) && len > off) {
            --len;
        }
        if (len != 0) {
            String msg = new String(b, off, len);
            this.category.log(this.priority, (Object)msg);
        }
        this.inWrite = false;
    }
}

