/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;

public class DelegatingURLConnection
extends URLConnection {
    protected URL delegateUrl;
    protected URLConnection delegateConnection;

    public DelegatingURLConnection(URL url) throws MalformedURLException, IOException {
        super(url);
        this.delegateUrl = this.makeDelegateUrl(url);
        this.delegateConnection = this.makeDelegateUrlConnection(this.delegateUrl);
    }

    protected URL makeDelegateUrl(URL url) throws MalformedURLException, IOException {
        return url;
    }

    protected URLConnection makeDelegateUrlConnection(URL url) throws IOException {
        return url.openConnection();
    }

    public void connect() throws IOException {
        this.delegateConnection.connect();
    }

    public Object getContent() throws IOException {
        return this.delegateConnection.getContent();
    }

    public String getContentType() {
        return this.delegateConnection.getContentType();
    }

    public InputStream getInputStream() throws IOException {
        return this.delegateConnection.getInputStream();
    }

    public String getHeaderField(String name) {
        return this.delegateConnection.getHeaderField(name);
    }

    public Permission getPermission() throws IOException {
        return this.delegateConnection.getPermission();
    }
}

