/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.njar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;

public class Handler
extends URLStreamHandler {
    public static final String PROTOCOL = "njar";
    public static final String NJAR_SEPARATOR = "^/";
    public static final String JAR_SEPARATOR = "!/";
    protected Map savedJars = new HashMap();

    public URLConnection openConnection(URL url) throws IOException {
        String file;
        String embeddedURL = file = url.getFile();
        String jarPath = "";
        int pos = file.lastIndexOf(NJAR_SEPARATOR);
        if (pos >= 0) {
            embeddedURL = file.substring(0, pos);
            if (file.length() > pos + NJAR_SEPARATOR.length()) {
                jarPath = file.substring(pos + NJAR_SEPARATOR.length());
            }
        }
        if (embeddedURL.startsWith(PROTOCOL)) {
            File tempJar = (File)this.savedJars.get(embeddedURL);
            if (tempJar == null) {
                InputStream embededData = new URL(embeddedURL).openStream();
                tempJar = File.createTempFile("nested-", ".jar");
                tempJar.deleteOnExit();
                this.storeJar(embededData, new FileOutputStream(tempJar));
                this.savedJars.put(embeddedURL, tempJar);
            }
            String t = tempJar.getCanonicalFile().toURL().toExternalForm();
            t = "njar:" + t + NJAR_SEPARATOR + jarPath;
            return new URL(t).openConnection();
        }
        return new URL("jar:" + embeddedURL + JAR_SEPARATOR + jarPath).openConnection();
    }

    /*
     * WARNING - void declaration
     */
    protected void storeJar(InputStream in, OutputStream out) throws IOException {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            int c;
            bis = new BufferedInputStream(in);
            bos = new BufferedOutputStream(out);
            byte[] data = new byte[512];
            while ((c = bis.read(data)) >= 0) {
                void var6_6;
                bos.write(data, 0, (int)var6_6);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                bis.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            try {
                bos.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bis.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            bos.close();
        }
        catch (IOException ignore) {}
    }

    public static URL njarToFile(URL url) {
        if (url.getProtocol().equals(PROTOCOL)) {
            try {
                URL dummy = new URL("njar:" + url.toString() + NJAR_SEPARATOR + "dummy.jar");
                String tmp = dummy.openConnection().getURL().toString();
                tmp = tmp.substring("jar:".length());
                tmp = tmp.substring(0, tmp.length() - "!/dummy.jar".length());
                return new URL(tmp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return url;
    }
}

