/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.jboss.util.EmptyStringException;
import org.jboss.util.NullArgumentException;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.UnreachableStatementException;

public final class Classes {
    public static final String PACKAGE_SEPARATOR = ".";
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String DEFAULT_PACKAGE_NAME = "<default>";
    private static final Class[] PRIMITIVE_WRAPPER_MAP = new Class[]{Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = Classes.class$("java.lang.Boolean")) : class$java$lang$Boolean, Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = Classes.class$("java.lang.Byte")) : class$java$lang$Byte, Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = Classes.class$("java.lang.Character")) : class$java$lang$Character, Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = Classes.class$("java.lang.Double")) : class$java$lang$Double, Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = Classes.class$("java.lang.Float")) : class$java$lang$Float, Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = Classes.class$("java.lang.Integer")) : class$java$lang$Integer, Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = Classes.class$("java.lang.Long")) : class$java$lang$Long, Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = Classes.class$("java.lang.Short")) : class$java$lang$Short};
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    public static String stripPackageName(String classname) {
        int idx = classname.lastIndexOf(PACKAGE_SEPARATOR);
        if (idx != -1) {
            return classname.substring(idx + 1, classname.length());
        }
        return classname;
    }

    public static String stripPackageName(Class type) {
        return Classes.stripPackageName(type.getName());
    }

    public static String getPackageName(String classname) {
        if (classname.length() == 0) {
            throw new EmptyStringException();
        }
        int index = classname.lastIndexOf(PACKAGE_SEPARATOR);
        if (index != -1) {
            return classname.substring(0, index);
        }
        return "";
    }

    public static String getPackageName(Class type) {
        return Classes.getPackageName(type.getName());
    }

    public static void forceLoad(Class type) {
        if (type == null) {
            throw new NullArgumentException("type");
        }
        if (type.isPrimitive()) {
            return;
        }
        String packageName = Classes.getPackageName(type);
        if (packageName.startsWith("java.") || packageName.startsWith("javax.")) {
            return;
        }
        try {
            Method[] methods = type.getDeclaredMethods();
            Method method = null;
            int i = 0;
            while (i < methods.length) {
                int modifiers = methods[i].getModifiers();
                if (Modifier.isStatic(modifiers)) {
                    method = methods[i];
                    break;
                }
                ++i;
            }
            if (method != null) {
                method.invoke(null, null);
            } else {
                type.newInstance();
            }
        }
        catch (Exception ignore) {
            ThrowableHandler.add(ignore);
        }
    }

    public static Class getPrimitiveWrapper(Class type) {
        if (!type.isPrimitive()) {
            throw new IllegalArgumentException("type is not a primitive class");
        }
        int i = 0;
        while (i < PRIMITIVE_WRAPPER_MAP.length) {
            if (type.equals(PRIMITIVE_WRAPPER_MAP[i])) {
                return PRIMITIVE_WRAPPER_MAP[i + 1];
            }
            i += 2;
        }
        throw new UnreachableStatementException();
    }

    public static boolean isPrimitiveWrapper(Class type) {
        int i = 0;
        while (i < PRIMITIVE_WRAPPER_MAP.length) {
            if (type.equals(PRIMITIVE_WRAPPER_MAP[i + 1])) {
                return true;
            }
            i += 2;
        }
        return false;
    }

    public static boolean isPrimitive(Class type) {
        return type.isPrimitive() || Classes.isPrimitiveWrapper(type);
    }

    private Classes() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

