/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.stream;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.util.ThrowableHandler;

public final class Streams {
    public static final int DEFAULT_BUFFER_SIZE = 2048;

    public static boolean close(InputStream stream) {
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
            ThrowableHandler.add(e);
        }
        return success;
    }

    public static boolean close(OutputStream stream) {
        boolean success = true;
        try {
            stream.close();
        }
        catch (IOException e) {
            success = false;
            ThrowableHandler.add(e);
        }
        return success;
    }

    public static boolean close(Object stream) {
        boolean success = false;
        if (stream instanceof InputStream) {
            success = Streams.close((InputStream)stream);
        } else if (stream instanceof OutputStream) {
            success = Streams.close((OutputStream)stream);
        } else {
            throw new IllegalArgumentException("stream is not an InputStream or OutputStream");
        }
        return success;
    }

    public static boolean close(InputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.close(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean close(OutputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.close(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean close(Object[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.close(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean fclose(OutputStream stream) {
        return Streams.flush(stream) && Streams.close(stream);
    }

    public static boolean fclose(OutputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.fclose(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    public static boolean flush(OutputStream stream) {
        boolean success = true;
        try {
            stream.flush();
        }
        catch (IOException e) {
            success = false;
            ThrowableHandler.add(e);
        }
        return success;
    }

    public static boolean flush(OutputStream[] streams) {
        boolean success = true;
        int i = 0;
        while (i < streams.length) {
            boolean rv = Streams.flush(streams[i]);
            if (!rv) {
                success = false;
            }
            ++i;
        }
        return success;
    }

    /*
     * WARNING - void declaration
     */
    public static long copy(InputStream input, OutputStream output, byte[] buffer) throws IOException {
        int read;
        long total = 0L;
        while ((read = input.read(buffer)) != -1) {
            void var5_4;
            output.write(buffer, 0, (int)var5_4);
            total += (long)var5_4;
        }
        return total;
    }

    public static long copy(InputStream input, OutputStream output, int size) throws IOException {
        return Streams.copy(input, output, new byte[size]);
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 2048);
    }

    /*
     * WARNING - void declaration
     */
    public static long copySome(InputStream input, OutputStream output, byte[] buffer, long length) throws IOException {
        int read;
        long total = 0L;
        int readLength = Math.min((int)length, buffer.length);
        while (readLength != 0 && (read = input.read(buffer, 0, readLength)) != -1) {
            void var7_6;
            output.write(buffer, 0, (int)var7_6);
            readLength = Math.min((int)(length - (total += (long)var7_6)), buffer.length);
        }
        return total;
    }

    public static long copySome(InputStream input, OutputStream output, int size, long length) throws IOException {
        return Streams.copySome(input, output, new byte[size], length);
    }

    public static long copySome(InputStream input, OutputStream output, long length) throws IOException {
        return Streams.copySome(input, output, 2048, length);
    }
}

