/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.net.protocol.njar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.ThrowableHandler;
import org.jboss.util.stream.Streams;

public class Handler
extends URLStreamHandler {
    public static final String PROTOCOL = "njar";
    public static final String NJAR_SEPARATOR = "^/";
    public static final String JAR_SEPARATOR = "!/";
    private static final Logger log = Logger.getLogger(class$org$jboss$net$protocol$njar$Handler == null ? (class$org$jboss$net$protocol$njar$Handler = Handler.class$("org.jboss.net.protocol.njar.Handler")) : class$org$jboss$net$protocol$njar$Handler);
    protected Map savedJars = new HashMap();
    static /* synthetic */ Class class$org$jboss$net$protocol$njar$Handler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection openConnection(URL url) throws IOException {
        String file;
        String embeddedURL = file = url.getFile();
        String jarPath = "";
        boolean trace = log.isTraceEnabled();
        int pos = file.lastIndexOf(NJAR_SEPARATOR);
        if (pos >= 0) {
            embeddedURL = file.substring(0, pos);
            if (file.length() > pos + NJAR_SEPARATOR.length()) {
                jarPath = file.substring(pos + NJAR_SEPARATOR.length());
            }
        }
        if (embeddedURL.startsWith(PROTOCOL)) {
            File tempJar;
            if (trace) {
                log.trace("Opening next  nested jar: " + embeddedURL);
            }
            if ((tempJar = (File)this.savedJars.get(embeddedURL)) == null) {
                URLConnection embededDataConnection = new URL(embeddedURL).openConnection();
                if (trace) {
                    log.trace("Content length: " + embededDataConnection.getContentLength());
                }
                InputStream embededData = embededDataConnection.getInputStream();
                tempJar = File.createTempFile("nested-", ".jar");
                tempJar.deleteOnExit();
                if (trace) {
                    log.trace("temp file location : " + tempJar);
                }
                FileOutputStream output = new FileOutputStream(tempJar);
                try {
                    long bytes = Streams.copyb(embededData, output);
                    if (trace) {
                        log.trace("copied " + bytes + " bytes");
                    }
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    Streams.flush(output);
                    Streams.close(embededData);
                    Streams.close(output);
                    throw throwable;
                }
                Streams.flush(output);
                Streams.close(embededData);
                Streams.close(output);
                this.savedJars.put(embeddedURL, tempJar);
            }
            String t = tempJar.getCanonicalFile().toURL().toExternalForm();
            if (trace) {
                log.trace("file URL : " + t);
            }
            t = "njar:" + t + NJAR_SEPARATOR + jarPath;
            if (trace) {
                log.trace("Opening saved jar: " + t);
            }
            URL u = new URL(t);
            if (trace) {
                log.trace("Using URL: " + u);
            }
            return u.openConnection();
        }
        if (trace) {
            log.trace("Opening final nested jar: " + embeddedURL);
        }
        URL u = new URL("jar:" + embeddedURL + JAR_SEPARATOR + jarPath);
        if (trace) {
            log.trace("Using URL: " + u);
        }
        return u.openConnection();
    }

    public static URL njarToFile(URL url) {
        if (url.getProtocol().equals(PROTOCOL)) {
            try {
                URL dummy = new URL("njar:" + url.toString() + NJAR_SEPARATOR + "dummy.jar");
                String tmp = dummy.openConnection().getURL().toString();
                tmp = tmp.substring("jar:".length());
                tmp = tmp.substring(0, tmp.length() - "!/dummy.jar".length());
                return new URL(tmp);
            }
            catch (Exception ignore) {
                ThrowableHandler.addWarning(ignore);
            }
        }
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

