/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xml.binding;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.util.Classes;
import org.jboss.xml.binding.DelegatingObjectModelProvider;
import org.jboss.xml.binding.GenericObjectModelProvider;
import org.jboss.xml.binding.ObjectModelProvider;
import org.jboss.xml.binding.TypeConverter;

public class MappingObjectModelProvider
implements GenericObjectModelProvider {
    private static final Logger log = Logger.getLogger(MappingObjectModelProvider.class);
    private final Map classMappings = new HashMap();
    private final Map fieldMappings = new HashMap();

    public void mapClassToElement(Class cls, String namespaceURI, String localName, ObjectModelProvider provider) {
        ClassToElementMapping mapping = new ClassToElementMapping(cls, namespaceURI, localName, provider instanceof GenericObjectModelProvider ? (GenericObjectModelProvider)provider : new DelegatingObjectModelProvider(provider));
        this.classMappings.put(mapping.cls, mapping);
    }

    public void mapFieldToElement(Class cls, String field, String namespaceURI, String localName, TypeConverter converter) {
        FieldToElementMapping mapping = new FieldToElementMapping(cls, field, namespaceURI, localName, converter);
        this.fieldMappings.put(mapping.localName, mapping);
    }

    public Object getChildren(Object o, String namespaceURI, String localName) {
        Object children = null;
        Class<?> cls = o.getClass();
        if (!this.writeAsValue(cls)) {
            try {
                FieldToElementMapping mapping = (FieldToElementMapping)this.fieldMappings.get(localName);
                Method getter = mapping != null ? mapping.getter : Classes.getAttributeGetter(cls, localName);
                if (!this.writeAsValue(getter.getReturnType())) {
                    children = getter.invoke(o, null);
                }
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("getChildren: no getter for " + localName + " in " + cls);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke getter for field " + localName + " in " + cls);
            }
        }
        return children;
    }

    public Object getElementValue(Object o, String namespaceURI, String localName) {
        Object value = null;
        if (this.writeAsValue(o.getClass())) {
            value = o;
        } else {
            Class<?> cls = o.getClass();
            try {
                FieldToElementMapping mapping = (FieldToElementMapping)this.fieldMappings.get(localName);
                Method getter = mapping != null ? mapping.getter : Classes.getAttributeGetter(cls, localName);
                value = getter.invoke(o, null);
                if (mapping != null) {
                    value = mapping.converter.marshal(value);
                }
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("getElementValue: no getter for " + localName + " in " + cls);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke getter for field " + localName + " in " + cls);
            }
        }
        return value;
    }

    public Object getAttributeValue(Object o, String namespaceURI, String localName) {
        Object value = null;
        if (this.writeAsValue(o.getClass())) {
            value = o;
        } else {
            Class<?> cls = o.getClass();
            try {
                FieldToElementMapping mapping = (FieldToElementMapping)this.fieldMappings.get(localName);
                Method getter = mapping != null ? mapping.getter : Classes.getAttributeGetter(cls, localName);
                value = getter.invoke(o, null);
                if (mapping != null) {
                    value = mapping.converter.marshal(value);
                }
            }
            catch (NoSuchMethodException e) {
                if (log.isDebugEnabled()) {
                    log.debug("getElementValue: no getter for " + localName + " in " + cls);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to invoke getter for field " + localName + " in " + cls);
            }
        }
        return value;
    }

    public Object getRoot(Object o, String namespaceURI, String localName) {
        return o;
    }

    private boolean writeAsValue(Class type) {
        return Classes.isPrimitive(type) || type == String.class || type == Date.class;
    }

    private class FieldToElementMapping {
        public final Class cls;
        public final String field;
        public final String namespaceURI;
        public final String localName;
        public final TypeConverter converter;
        public final Method getter;
        public final Method setter;

        public FieldToElementMapping(Class cls, String field, String namespaceURI, String localName, TypeConverter converter) {
            this.cls = cls;
            this.field = field;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.converter = converter;
            try {
                this.getter = Classes.getAttributeGetter(cls, field);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Getter not found for " + field + " in class " + cls.getName());
            }
            try {
                this.setter = Classes.getAttributeSetter(cls, field, this.getter.getReturnType());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Setter not found for " + field + " in class " + cls.getName());
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FieldToElementMapping)) {
                return false;
            }
            FieldToElementMapping fieldToElementMapping = (FieldToElementMapping)o;
            if (this.cls != null ? !this.cls.equals(fieldToElementMapping.cls) : fieldToElementMapping.cls != null) {
                return false;
            }
            if (this.field != null ? !this.field.equals(fieldToElementMapping.field) : fieldToElementMapping.field != null) {
                return false;
            }
            if (this.localName != null ? !this.localName.equals(fieldToElementMapping.localName) : fieldToElementMapping.localName != null) {
                return false;
            }
            return !(this.namespaceURI != null ? !this.namespaceURI.equals(fieldToElementMapping.namespaceURI) : fieldToElementMapping.namespaceURI != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.field != null ? this.field.hashCode() : 0);
            result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
            result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
            return result;
        }
    }

    private class ClassToElementMapping {
        public final Class cls;
        public final String namespaceURI;
        public final String localName;
        public final GenericObjectModelProvider provider;

        public ClassToElementMapping(Class cls, String namespaceURI, String localName, GenericObjectModelProvider provider) {
            this.cls = cls;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            this.provider = provider;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassToElementMapping)) {
                return false;
            }
            ClassToElementMapping classToElementMapping = (ClassToElementMapping)o;
            if (this.cls != null ? !this.cls.equals(classToElementMapping.cls) : classToElementMapping.cls != null) {
                return false;
            }
            if (this.localName != null ? !this.localName.equals(classToElementMapping.localName) : classToElementMapping.localName != null) {
                return false;
            }
            return !(this.namespaceURI != null ? !this.namespaceURI.equals(classToElementMapping.namespaceURI) : classToElementMapping.namespaceURI != null);
        }

        public int hashCode() {
            int result = this.cls != null ? this.cls.hashCode() : 0;
            result = 29 * result + (this.namespaceURI != null ? this.namespaceURI.hashCode() : 0);
            result = 29 * result + (this.localName != null ? this.localName.hashCode() : 0);
            return result;
        }
    }
}

