/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.iiop;

import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.iiop.CorbaORB;
import org.jboss.iiop.CorbaORBServiceMBean;
import org.jboss.system.ORBSingleton;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.system.server.ServerConfigUtil;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.IdAssignmentPolicy;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.LifespanPolicy;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class CorbaORBService
extends ServiceMBeanSupport
implements CorbaORBServiceMBean,
ObjectFactory {
    public static String ORB_NAME = "JBossCorbaORB";
    public static String POA_NAME = "JBossCorbaPOA";
    public static String IR_POA_NAME = "JBossCorbaInterfaceRepositoryPOA";
    private String orbClass = null;
    private String orbSingletonClass = null;
    private String orbSingletonDelegate = null;
    private String orbPropertiesFileName = "orb-properties-file-not-defined";
    private String portableInterceptorInitializerClass = null;
    private Integer port = null;
    private static ORB orb;
    private static POA poa;
    private static POA irPoa;

    protected void createService() throws Exception {
        String jacorbVerbosity;
        Properties props = new Properties();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(this.orbPropertiesFileName);
        props.load(is);
        String oaiAddr = props.getProperty("OAIAddr");
        if (oaiAddr == null) {
            oaiAddr = ServerConfigUtil.getSpecificBindAddress();
        }
        if (oaiAddr != null) {
            props.setProperty("OAIAddr", oaiAddr);
        }
        this.log.info((java.lang.Object)("Using OAIAddr=" + oaiAddr));
        Properties systemProps = System.getProperties();
        if (this.orbClass != null) {
            props.put("org.omg.CORBA.ORBClass", this.orbClass);
            systemProps.put("org.omg.CORBA.ORBClass", this.orbClass);
        }
        if (this.orbSingletonClass != null) {
            props.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
            systemProps.put("org.omg.CORBA.ORBSingletonClass", this.orbSingletonClass);
        }
        if (this.orbSingletonDelegate != null) {
            systemProps.put(ORBSingleton.DELEGATE_CLASS_KEY, this.orbSingletonDelegate);
        }
        if ((jacorbVerbosity = props.getProperty("jacorb.verbosity")) != null) {
            systemProps.put("jacorb.verbosity", jacorbVerbosity);
        }
        System.setProperties(systemProps);
        if (this.portableInterceptorInitializerClass != null) {
            props.put("org.omg.PortableInterceptor.ORBInitializerClass." + this.portableInterceptorInitializerClass, "");
        }
        if (this.port != null) {
            props.put("OAPort", this.port.toString());
        }
        orb = ORB.init((String[])new String[0], (Properties)props);
        this.bind(ORB_NAME, "org.omg.CORBA.ORB");
        CorbaORB.setInstance(orb);
        poa = POAHelper.narrow((Object)orb.resolve_initial_references("RootPOA"));
        poa.the_POAManager().activate();
        this.bind(POA_NAME, "org.omg.PortableServer.POA");
        new Thread(new Runnable(){

            public void run() {
                orb.run();
            }
        }, "ORB thread").start();
        try {
            LifespanPolicy lifespanPolicy = poa.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
            IdAssignmentPolicy idAssignmentPolicy = poa.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID);
            irPoa = poa.create_POA("IR", null, new Policy[]{lifespanPolicy, idAssignmentPolicy});
            this.bind(IR_POA_NAME, "org.omg.PortableServer.POA");
            irPoa.the_POAManager().activate();
        }
        catch (Exception ex) {
            this.getLog().error((java.lang.Object)"Error in IR POA initialization", (Throwable)ex);
        }
    }

    protected void destroyService() throws Exception {
        try {
            this.unbind(ORB_NAME);
            this.unbind(POA_NAME);
            this.unbind(IR_POA_NAME);
            orb.shutdown(false);
        }
        catch (Exception e) {
            this.log.error((java.lang.Object)"Exception while stopping ORB service", (Throwable)e);
        }
    }

    public String getORBClass() {
        return this.orbClass;
    }

    public void setORBClass(String orbClass) {
        this.orbClass = orbClass;
    }

    public String getORBSingletonClass() {
        return this.orbSingletonClass;
    }

    public void setORBSingletonClass(String orbSingletonClass) {
        this.orbSingletonClass = orbSingletonClass;
    }

    public String getORBSingletonDelegate() {
        return this.orbSingletonDelegate;
    }

    public void setORBSingletonDelegate(String orbSingletonDelegate) {
        this.orbSingletonDelegate = orbSingletonDelegate;
    }

    public void setORBPropertiesFileName(String orbPropertiesFileName) {
        this.orbPropertiesFileName = orbPropertiesFileName;
    }

    public String getORBPropertiesFileName() {
        return this.orbPropertiesFileName;
    }

    public String getPortableInterceptorInitializerClass() {
        return this.portableInterceptorInitializerClass;
    }

    public void setPortableInterceptorInitializerClass(String portableInterceptorInitializerClass) {
        this.portableInterceptorInitializerClass = portableInterceptorInitializerClass;
    }

    public void setPort(int port) {
        this.port = new Integer(port);
    }

    public int getPort() {
        return this.port;
    }

    public java.lang.Object getObjectInstance(java.lang.Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        String s = name.toString();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((java.lang.Object)("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s));
        }
        if (ORB_NAME.equals(s)) {
            return orb;
        }
        if (POA_NAME.equals(s)) {
            return poa;
        }
        if (IR_POA_NAME.equals(s)) {
            return irPoa;
        }
        return null;
    }

    private void bind(String name, String className) throws Exception {
        Reference ref = new Reference(className, this.getClass().getName(), null);
        new InitialContext().bind("java:/" + name, (java.lang.Object)ref);
    }

    private void unbind(String name) throws Exception {
        new InitialContext().unbind("java:/" + name);
    }
}

