/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.iiop;

import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;
import org.jboss.iiop.CorbaORBService;
import org.jboss.invocation.iiop.IIOPInvokerMBean;
import org.jboss.invocation.iiop.ReferenceData;
import org.jboss.invocation.iiop.ReferenceFactory;
import org.jboss.invocation.iiop.ServantRegistries;
import org.jboss.invocation.iiop.ServantRegistry;
import org.jboss.invocation.iiop.ServantRegistryKind;
import org.jboss.invocation.iiop.ServantWithMBeanServer;
import org.jboss.naming.Util;
import org.jboss.system.Registry;
import org.jboss.system.ServiceMBeanSupport;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SetOverrideType;
import org.omg.CORBA.UNKNOWN;
import org.omg.PortableServer.IdAssignmentPolicyValue;
import org.omg.PortableServer.IdUniquenessPolicyValue;
import org.omg.PortableServer.LifespanPolicyValue;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.RequestProcessingPolicyValue;
import org.omg.PortableServer.Servant;
import org.omg.PortableServer.ServantLocator;
import org.omg.PortableServer.ServantLocatorPackage.CookieHolder;
import org.omg.PortableServer.ServantManager;
import org.omg.PortableServer.ServantRetentionPolicyValue;

public class IIOPInvoker
extends ServiceMBeanSupport
implements IIOPInvokerMBean,
ServantRegistries,
ObjectFactory {
    private static IIOPInvoker theIIOPInvoker;
    private POA rootPOA;
    private ServantRegistry registryWithSharedTransientPOA;
    private POA transientPOA;
    private Map transientServantMap;
    private ServantRegistry registryWithSharedPersistentPOA;
    private POA persistentPOA;
    private Map persistentServantMap;
    private ServantRegistry registryWithTransientPOAPerServant;
    private Map transientPoaMap;
    private Policy[] transientPoaPolicies;
    private ServantRegistry registryWithPersistentPOAPerServant;
    private Map persistentPoaMap;
    private Policy[] persistentPoaPolicies;

    public void createService() throws Exception {
        theIIOPInvoker = this;
        this.transientServantMap = Collections.synchronizedMap(new HashMap());
        this.persistentServantMap = Collections.synchronizedMap(new HashMap());
        this.transientPoaMap = Collections.synchronizedMap(new HashMap());
        this.persistentPoaMap = Collections.synchronizedMap(new HashMap());
        try {
            this.rootPOA = (POA)new InitialContext().lookup("java:/" + CorbaORBService.POA_NAME);
        }
        catch (NamingException e) {
            throw new RuntimeException("Cannot lookup java:/" + CorbaORBService.POA_NAME + ": " + e);
        }
        this.transientPoaPolicies = new Policy[]{this.rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
        this.persistentPoaPolicies = new Policy[]{this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT), this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_DEFAULT_SERVANT), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
        Policy[] policies = new Policy[]{this.rootPOA.create_lifespan_policy(LifespanPolicyValue.TRANSIENT), this.rootPOA.create_id_assignment_policy(IdAssignmentPolicyValue.USER_ID), this.rootPOA.create_servant_retention_policy(ServantRetentionPolicyValue.NON_RETAIN), this.rootPOA.create_request_processing_policy(RequestProcessingPolicyValue.USE_SERVANT_MANAGER), this.rootPOA.create_id_uniqueness_policy(IdUniquenessPolicyValue.MULTIPLE_ID)};
        this.transientPOA = this.rootPOA.create_POA("TPOA", null, policies);
        this.transientPOA.set_servant_manager((ServantManager)new TransientServantLocator());
        policies[0] = this.rootPOA.create_lifespan_policy(LifespanPolicyValue.PERSISTENT);
        this.persistentPOA = this.rootPOA.create_POA("PPOA", null, policies);
        this.persistentPOA.set_servant_manager((ServantManager)new PersistentServantLocator());
        this.registryWithSharedTransientPOA = new ServantRegistryWithSharedTransientPOA();
        this.registryWithSharedPersistentPOA = new ServantRegistryWithSharedPersistentPOA();
        this.registryWithTransientPOAPerServant = new ServantRegistryWithTransientPOAPerServant();
        this.registryWithPersistentPOAPerServant = new ServantRegistryWithPersistentPOAPerServant();
    }

    public void startService() throws Exception {
        Registry.bind((java.lang.Object)this.getServiceName(), (java.lang.Object)this);
        this.transientPOA.the_POAManager().activate();
        this.persistentPOA.the_POAManager().activate();
        InitialContext context = new InitialContext();
        Util.rebind((Context)context, (String)("invokers/" + InetAddress.getLocalHost().getHostName() + "/iiop"), (java.lang.Object)new Reference(this.getClass().getName(), this.getClass().getName(), null));
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((java.lang.Object)"Bound IIOP invoker for JMX node");
        }
    }

    public void stopService() throws Exception {
        try {
            this.transientPOA.the_POAManager().deactivate(false, true);
            this.persistentPOA.the_POAManager().deactivate(false, true);
            this.transientPOA.destroy(false, false);
            this.persistentPOA.destroy(false, false);
        }
        catch (AdapterInactive adapterInactive) {
            this.getLog().error((java.lang.Object)"Cannot deactivate home POA", (Throwable)adapterInactive);
        }
    }

    private static Policy[] concatPolicies(Policy[] policies1, Policy[] policies2) {
        Policy[] policies = new Policy[policies1.length + policies2.length];
        int j = 0;
        int i = 0;
        while (i < policies1.length) {
            policies[j] = policies1[i];
            ++i;
            ++j;
        }
        int i2 = 0;
        while (i2 < policies2.length) {
            policies[j] = policies2[i2];
            ++i2;
            ++j;
        }
        return policies;
    }

    public ServantRegistry getServantRegistry(ServantRegistryKind kind) {
        if (kind == ServantRegistryKind.SHARED_TRANSIENT_POA) {
            return this.registryWithSharedTransientPOA;
        }
        if (kind == ServantRegistryKind.SHARED_PERSISTENT_POA) {
            return this.registryWithSharedPersistentPOA;
        }
        if (kind == ServantRegistryKind.TRANSIENT_POA_PER_SERVANT) {
            return this.registryWithTransientPOAPerServant;
        }
        if (kind == ServantRegistryKind.PERSISTENT_POA_PER_SERVANT) {
            return this.registryWithPersistentPOAPerServant;
        }
        return null;
    }

    public java.lang.Object getObjectInstance(java.lang.Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        String s = name.toString();
        if (this.getLog().isTraceEnabled()) {
            this.getLog().trace((java.lang.Object)("getObjectInstance: obj.getClass().getName=\"" + obj.getClass().getName() + "\n                   name=" + s));
        }
        if (s.equals("iiop")) {
            return theIIOPInvoker;
        }
        return null;
    }

    class PersistentServantLocator
    extends LocalObject
    implements ServantLocator {
        PersistentServantLocator() {
        }

        public Servant preinvoke(byte[] oid, POA adapter, String operation, CookieHolder the_cookie) {
            try {
                the_cookie.value = null;
                java.lang.Object id = ReferenceData.extractServantId(oid);
                return (Servant)IIOPInvoker.this.persistentServantMap.get(id);
            }
            catch (Exception e) {
                IIOPInvoker.this.getLog().trace((java.lang.Object)"Unexpected exception in preinvoke:", (Throwable)e);
                throw new UNKNOWN(e.toString());
            }
        }

        public void postinvoke(byte[] oid, POA adapter, String operation, java.lang.Object the_cookie, Servant the_servant) {
        }
    }

    class TransientServantLocator
    extends LocalObject
    implements ServantLocator {
        TransientServantLocator() {
        }

        public Servant preinvoke(byte[] oid, POA adapter, String operation, CookieHolder the_cookie) {
            try {
                the_cookie.value = null;
                java.lang.Object id = ReferenceData.extractServantId(oid);
                return (Servant)IIOPInvoker.this.transientServantMap.get(id);
            }
            catch (Exception e) {
                IIOPInvoker.this.getLog().trace((java.lang.Object)"Unexpected exception in preinvoke:", (Throwable)e);
                throw new UNKNOWN(e.toString());
            }
        }

        public void postinvoke(byte[] oid, POA adapter, String operation, java.lang.Object the_cookie, Servant the_servant) {
        }
    }

    class ServantRegistryWithPersistentPOAPerServant
    implements ServantRegistry {
        ServantRegistryWithPersistentPOAPerServant() {
        }

        public ReferenceFactory bind(String name, Servant servant, Policy[] policies) throws Exception {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            Policy[] poaPolicies = IIOPInvoker.concatPolicies(IIOPInvoker.this.persistentPoaPolicies, policies);
            POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, poaPolicies);
            IIOPInvoker.this.persistentPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        public ReferenceFactory bind(String name, Servant servant) throws Exception {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, IIOPInvoker.this.persistentPoaPolicies);
            IIOPInvoker.this.persistentPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        public void unbind(String name) throws Exception {
            POA poa = (POA)IIOPInvoker.this.persistentPoaMap.remove(name);
            if (poa != null) {
                poa.the_POAManager().deactivate(false, true);
                poa.destroy(false, false);
            }
        }
    }

    class ServantRegistryWithTransientPOAPerServant
    implements ServantRegistry {
        ServantRegistryWithTransientPOAPerServant() {
        }

        public ReferenceFactory bind(String name, Servant servant, Policy[] policies) throws Exception {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            Policy[] poaPolicies = IIOPInvoker.concatPolicies(IIOPInvoker.this.transientPoaPolicies, policies);
            POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, poaPolicies);
            IIOPInvoker.this.transientPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        public ReferenceFactory bind(String name, Servant servant) throws Exception {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            POA poa = IIOPInvoker.this.rootPOA.create_POA(name, null, IIOPInvoker.this.transientPoaPolicies);
            IIOPInvoker.this.transientPoaMap.put(name, poa);
            poa.set_servant(servant);
            poa.the_POAManager().activate();
            return new PoaReferenceFactory(poa);
        }

        public void unbind(String name) throws Exception {
            POA poa = (POA)IIOPInvoker.this.transientPoaMap.remove(name);
            if (poa != null) {
                poa.the_POAManager().deactivate(false, true);
                poa.destroy(false, false);
            }
        }
    }

    class ServantRegistryWithSharedPersistentPOA
    implements ServantRegistry {
        ServantRegistryWithSharedPersistentPOA() {
        }

        public ReferenceFactory bind(String name, Servant servant, Policy[] policies) {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            IIOPInvoker.this.persistentServantMap.put(name, servant);
            return new PoaAndPoliciesReferenceFactory(IIOPInvoker.this.persistentPOA, name, policies);
        }

        public ReferenceFactory bind(String name, Servant servant) {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            IIOPInvoker.this.persistentServantMap.put(name, servant);
            return new PoaReferenceFactory(IIOPInvoker.this.persistentPOA, name);
        }

        public void unbind(String name) {
            IIOPInvoker.this.persistentServantMap.remove(name);
        }
    }

    class ServantRegistryWithSharedTransientPOA
    implements ServantRegistry {
        ServantRegistryWithSharedTransientPOA() {
        }

        public ReferenceFactory bind(String name, Servant servant, Policy[] policies) {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            IIOPInvoker.this.transientServantMap.put(name, servant);
            return new PoaAndPoliciesReferenceFactory(IIOPInvoker.this.transientPOA, name, policies);
        }

        public ReferenceFactory bind(String name, Servant servant) {
            if (servant instanceof ServantWithMBeanServer) {
                ((ServantWithMBeanServer)servant).setMBeanServer(IIOPInvoker.this.getServer());
            }
            IIOPInvoker.this.transientServantMap.put(name, servant);
            return new PoaReferenceFactory(IIOPInvoker.this.transientPOA, name);
        }

        public void unbind(String name) {
            IIOPInvoker.this.transientServantMap.remove(name);
        }
    }

    static class PoaReferenceFactory
    implements ReferenceFactory {
        private POA poa;
        private String servantName;
        private byte[] servantId;

        PoaReferenceFactory(POA poa, String servantName) {
            this.poa = poa;
            this.servantName = servantName;
            this.servantId = ReferenceData.create(servantName);
        }

        PoaReferenceFactory(POA poa) {
            this(poa, null);
        }

        public Object createReference(String interfId) throws Exception {
            return this.poa.create_reference_with_id(this.servantId, interfId);
        }

        public Object createReferenceWithId(java.lang.Object id, String interfId) throws Exception {
            byte[] referenceData = this.servantName == null ? ReferenceData.create(id) : ReferenceData.create(this.servantName, id);
            return this.poa.create_reference_with_id(referenceData, interfId);
        }

        public POA getPOA() {
            return this.poa;
        }
    }

    static class PoaAndPoliciesReferenceFactory
    implements ReferenceFactory {
        private POA poa;
        private String servantName;
        private Policy[] policies;
        private byte[] servantId;

        PoaAndPoliciesReferenceFactory(POA poa, String servantName, Policy[] policies) {
            this.poa = poa;
            this.servantName = servantName;
            this.policies = policies;
            this.servantId = ReferenceData.create(servantName);
        }

        PoaAndPoliciesReferenceFactory(POA poa, Policy[] policies) {
            this(poa, null, policies);
        }

        public Object createReference(String interfId) throws Exception {
            Object corbaRef = this.poa.create_reference_with_id(this.servantId, interfId);
            return corbaRef._set_policy_override(this.policies, SetOverrideType.ADD_OVERRIDE);
        }

        public Object createReferenceWithId(java.lang.Object id, String interfId) throws Exception {
            byte[] referenceData = this.servantName == null ? ReferenceData.create(id) : ReferenceData.create(this.servantName, id);
            Object corbaRef = this.poa.create_reference_with_id(referenceData, interfId);
            return corbaRef._set_policy_override(this.policies, SetOverrideType.ADD_OVERRIDE);
        }

        public POA getPOA() {
            return this.poa;
        }
    }
}

