/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

class URLPattern {
    static final int DEFAULT = 0;
    static final int THE_PATH_PREFIX = 1;
    static final int PATH_PREFIX = 2;
    static final int EXTENSION = 3;
    static final int EXACT = 4;
    private String pattern;
    private String ext;
    private int length;
    private int type = -1;

    URLPattern(String pattern) {
        this.pattern = pattern;
        this.length = pattern.length();
        if (pattern.equals("/")) {
            this.type = 0;
        } else if (pattern.startsWith("/*")) {
            this.type = 1;
        } else if (pattern.charAt(0) == '/' && pattern.endsWith("/*")) {
            this.type = 2;
        } else if (pattern.startsWith("*.")) {
            this.type = 3;
            this.ext = pattern.substring(1);
        } else {
            this.type = 4;
        }
    }

    boolean matches(URLPattern url) {
        if (this.type == 0 || this.type == 1) {
            return true;
        }
        if (this.type == 3 && url.pattern.endsWith(this.ext)) {
            return true;
        }
        if (this.type == 2) {
            if (url.pattern.regionMatches(0, this.pattern, 0, this.length - 2)) {
                int last = this.length - 2;
                return url.pattern.length() <= last || url.pattern.charAt(last) == '/';
            }
            return false;
        }
        return this.pattern.equals(url.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    boolean equals(URLPattern p) {
        boolean equals;
        boolean bl = equals = this.type == p.type;
        if (equals) {
            equals = this.pattern.equals(p.pattern);
        }
        return equals;
    }
}

