/*
 * Decompiled with CFR 0.152.
 */
package javax.security.jacc;

import java.io.Serializable;
import java.security.Permission;
import java.util.TreeSet;
import javax.security.jacc.URLPatternSpec;
import javax.security.jacc.WebResourcePermission;
import javax.servlet.http.HttpServletRequest;

public final class WebUserDataPermission
extends Permission
implements Serializable {
    private URLPatternSpec urlSpec;
    private String httpMethodsString;
    private String transportType;
    private TreeSet httpMethods;

    public WebUserDataPermission(HttpServletRequest request) {
        this(WebResourcePermission.requestURI(request), request.getMethod());
    }

    public WebUserDataPermission(String name, String actions) {
        super(name == null ? "/" : name);
        int colon;
        if (name == null) {
            name = "/";
        }
        this.urlSpec = new URLPatternSpec(name);
        if (actions != null && (colon = actions.indexOf(58)) >= 0) {
            this.transportType = actions.substring(colon + 1);
            if (this.transportType.equalsIgnoreCase("NONE")) {
                this.transportType = null;
            }
            actions = actions.substring(0, colon);
        }
        Object[] methodInfo = WebResourcePermission.canonicalMethods(actions);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
    }

    public WebUserDataPermission(String urlPatternSpec, String[] httpMethods, String transportType) {
        super(urlPatternSpec);
        Object[] methodInfo = WebResourcePermission.canonicalMethods(httpMethods);
        this.httpMethods = (TreeSet)methodInfo[0];
        this.httpMethodsString = (String)methodInfo[1];
        this.transportType = transportType;
    }

    public boolean equals(Object p) {
        boolean equals = false;
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        equals = this.urlSpec.equals(perm.urlSpec);
        if (equals) {
            String a0 = this.getActions();
            String a1 = perm.getActions();
            equals = a0 != null && a0.equals(a1) || a0 == a1;
        }
        return equals;
    }

    public String getActions() {
        String actions = null;
        if (this.httpMethodsString != null) {
            actions = this.transportType != null ? this.httpMethodsString + ":" + this.transportType : this.httpMethodsString;
        } else if (this.transportType != null) {
            actions = ":" + this.transportType;
        }
        return actions;
    }

    public int hashCode() {
        int hashCode = this.urlSpec.hash();
        if (this.httpMethods != null) {
            hashCode += this.httpMethods.hashCode();
        }
        return hashCode;
    }

    public boolean implies(Permission p) {
        if (p == null || !(p instanceof WebUserDataPermission)) {
            return false;
        }
        WebUserDataPermission perm = (WebUserDataPermission)p;
        boolean implies = this.urlSpec.implies(perm.urlSpec);
        if (implies) {
            if (this.httpMethods != null) {
                implies = this.httpMethods.containsAll(perm.httpMethods);
            }
            if (implies && this.transportType != null) {
                implies = this.transportType.equals(perm.transportType);
            }
        }
        return implies;
    }
}

