/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

public abstract class ServiceFactory {
    private static ServiceFactory factory;
    public static final String SERVICEFACTORY_PROPERTY = "javax.xml.rpc.ServiceFactory";

    protected ServiceFactory() {
    }

    public static synchronized ServiceFactory newInstance() throws ServiceException {
        if (factory == null) {
            String defaultService = null;
            PropertyAccessAction action = new PropertyAccessAction(SERVICEFACTORY_PROPERTY, defaultService);
            String factoryName = (String)AccessController.doPrivileged(action);
            if (factoryName == null) {
                throw new ServiceException("No javax.xml.rpc.ServiceFactory specified");
            }
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> factoryClass = loader.loadClass(factoryName);
                factory = (ServiceFactory)factoryClass.newInstance();
            }
            catch (Throwable e) {
                throw new ServiceException("Failed to create factory: " + factoryName, e);
            }
        }
        return factory;
    }

    public abstract Service loadService(Class var1) throws ServiceException;

    public abstract Service loadService(URL var1, Class var2, Properties var3) throws ServiceException;

    public abstract Service loadService(URL var1, QName var2, Properties var3) throws ServiceException;

    public abstract Service createService(QName var1) throws ServiceException;

    public abstract Service createService(URL var1, QName var2) throws ServiceException;

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

