/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public abstract class MessageFactory {
    private static final String DEFAULT_MSG_FACTORY = "org.apache.axis.soap.MessageFactoryImpl";

    public static MessageFactory newInstance() throws SOAPException {
        MessageFactory factory = null;
        String factoryName = null;
        try {
            factoryName = System.getProperty("javax.xml.soap.MessageFactory", DEFAULT_MSG_FACTORY);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(factoryName);
            factory = (MessageFactory)factoryClass.newInstance();
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create MessageFactory: " + factoryName, t);
        }
        return factory;
    }

    public abstract SOAPMessage createMessage() throws SOAPException;

    public abstract SOAPMessage createMessage(MimeHeaders var1, InputStream var2) throws IOException, SOAPException;
}

