/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;

public abstract class SOAPConnectionFactory {
    private static final String DEFAULT_CONN_FACTORY = "org.apache.axis.soap.SOAPConnectionFactoryImpl";

    public static SOAPConnectionFactory newInstance() throws SOAPException, UnsupportedOperationException {
        SOAPConnectionFactory factory = null;
        String factoryName = null;
        try {
            factoryName = System.getProperty("javax.xml.soap.SOAPConnectionFactory", DEFAULT_CONN_FACTORY);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(factoryName);
            factory = (SOAPConnectionFactory)factoryClass.newInstance();
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create SOAPConnectionFactory: " + factoryName, t);
        }
        return factory;
    }

    public abstract SOAPConnection createConnection() throws SOAPException;
}

