/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.soap;

import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;

public abstract class SOAPFactory {
    private static final String DEFAULT_FACTORY = "org.apache.axis.soap.SOAPFactoryImpl";

    public static SOAPFactory newInstance() throws SOAPException {
        SOAPFactory factory = null;
        String factoryName = null;
        try {
            factoryName = System.getProperty(DEFAULT_FACTORY, DEFAULT_FACTORY);
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> factoryClass = loader.loadClass(factoryName);
            factory = (SOAPFactory)factoryClass.newInstance();
        }
        catch (Throwable t) {
            throw new SOAPException("Failed to create SOAPConnectionFactory: " + factoryName, t);
        }
        return factory;
    }

    public abstract Detail createDetail() throws SOAPException;

    public abstract SOAPElement createElement(String var1) throws SOAPException;

    public abstract SOAPElement createElement(String var1, String var2, String var3) throws SOAPException;

    public abstract SOAPElement createElement(Name var1) throws SOAPException;

    public abstract Name createName(String var1) throws SOAPException;

    public abstract Name createName(String var1, String var2, String var3) throws SOAPException;
}

