/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Map;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import org.jboss.mx.util.MonitorCallback;
import org.jboss.mx.util.MonitorRunnable;
import org.jboss.mx.util.ObservedObject;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    int THRESHOLD_EXCEEDED_NOTIFIED = 16;
    int THRESHOLD_ERROR_NOTIFIED = 32;
    Number offset = new Integer(0);
    Number modulus = new Integer(0);
    Number initThreshold = new Integer(0);
    boolean differenceMode = false;
    boolean notify = false;
    private MonitorRunnable monitorRunnable;

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[1];
        String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.counter.threshold"};
        result[0] = new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the Counter Monitor Service MBean");
        return result;
    }

    public Number getDerivedGauge() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return (Number)object.getDerivedGauge();
        }
        return null;
    }

    public Number getDerivedGauge(ObjectName name) {
        ObservedObject object = this.retrieveObservedObject(name);
        if (object != null) {
            return (Number)object.getDerivedGauge();
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return object.getDerivedGaugeTimeStamp();
        }
        return 0L;
    }

    public long getDerivedGaugeTimeStamp(ObjectName name) {
        ObservedObject object = this.retrieveObservedObject(name);
        if (object != null) {
            return object.getDerivedGaugeTimeStamp();
        }
        return 0L;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public Number getInitThreshold() {
        return this.initThreshold;
    }

    public void setInitThreshold(Number threshold) throws IllegalArgumentException {
        if (threshold == null) {
            throw new IllegalArgumentException("Null threshold");
        }
        if (threshold.longValue() < 0L) {
            throw new IllegalArgumentException("Negative threshold");
        }
        this.initThreshold = threshold;
    }

    public Number getModulus() {
        return this.modulus;
    }

    public void setModulus(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null modulus");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative modulus");
        }
        this.modulus = value;
    }

    public boolean getNotify() {
        return this.notify;
    }

    public void setNotify(boolean value) {
        this.notify = value;
    }

    public Number getOffset() {
        return this.offset;
    }

    public void setOffset(Number value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null offset");
        }
        if (value.longValue() < 0L) {
            throw new IllegalArgumentException("Negative offset");
        }
        this.offset = value;
    }

    public Number getThreshold() {
        ObservedObject object = this.getFirstObservedObject();
        if (object != null) {
            return (Number)object.getThreshold();
        }
        return null;
    }

    public Number getThreshold(ObjectName name) {
        ObservedObject object = this.retrieveObservedObject(name);
        if (object != null) {
            return (Number)object.getThreshold();
        }
        return null;
    }

    public void setThreshold(Number value) throws IllegalArgumentException {
        this.setInitThreshold(value);
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        for (ObservedObject object : this.retrieveObservedObjects().values()) {
            this.initObservedObject(object);
        }
        MonitorCallback callback = new MonitorCallback(){

            public void monitorCallback(ObservedObject object, MBeanAttributeInfo attributeInfo, Object value) throws Exception {
                CounterMonitor.this.monitor(object, attributeInfo, value);
            }

            public MonitorNotification createNotification(String type, Object source, long timeStamp, String message, Object derivedGauge, String observedAttribute, ObjectName observedObject, Object trigger) {
                return new MonitorNotification(type, source, CounterMonitor.this.nextSeqNo(), timeStamp, message, derivedGauge, observedAttribute, observedObject, trigger);
            }
        };
        this.monitorRunnable = new MonitorRunnable((Monitor)this, this.objectName, callback, (Map)this.observedObjects, this.server);
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.monitorRunnable.setScheduler(null);
        this.monitorRunnable = null;
    }

    void initObservedObject(ObservedObject object) {
        super.initObservedObject(object);
        object.setDerivedGauge((Object)new Integer(0));
        object.setThreshold((Object)this.initThreshold);
        object.setLastValue(null);
    }

    void monitor(ObservedObject object, MBeanAttributeInfo attributeInfo, Object value) throws Exception {
        if (!(value instanceof Byte || value instanceof Integer || value instanceof Short || value instanceof Long)) {
            this.sendAttributeTypeErrorNotification(object, "Attribute is not an integer type");
            return;
        }
        Number threshold = (Number)object.getThreshold();
        if (threshold.getClass() != value.getClass() || this.offset.longValue() != 0L && this.offset.getClass() != value.getClass() || this.modulus.longValue() != 0L && this.modulus.getClass() != value.getClass()) {
            this.sendThresholdErrorNotification(object, value);
            return;
        }
        Number number = (Number)value;
        Number lastValue = (Number)object.getLastValue();
        Number derivedGauge = (Number)object.getDerivedGauge();
        if (this.differenceMode) {
            derivedGauge = lastValue == null ? (Number)this.getZero(number) : (Number)this.sub(number, lastValue);
            if (derivedGauge.longValue() < 0L && this.modulus.longValue() != 0L) {
                derivedGauge = this.add(derivedGauge, this.modulus);
                threshold = this.initThreshold;
                object.setThreshold((Object)threshold);
                object.setNotAlreadyNotified(this.THRESHOLD_EXCEEDED_NOTIFIED);
            }
        } else {
            derivedGauge = number;
        }
        object.setDerivedGauge((Object)derivedGauge);
        object.setDerivedGaugeTimeStamp(System.currentTimeMillis());
        if (lastValue != null && this.modulus.longValue() != 0L && this.offset.longValue() != 0L && derivedGauge.longValue() < lastValue.longValue()) {
            object.setNotAlreadyNotified(this.THRESHOLD_EXCEEDED_NOTIFIED);
        }
        if (derivedGauge.longValue() >= threshold.longValue()) {
            if (object.notAlreadyNotified(this.THRESHOLD_EXCEEDED_NOTIFIED)) {
                this.sendThresholdExceededNotification(object, derivedGauge);
                if (this.offset.longValue() != 0L) {
                    while (threshold.longValue() <= derivedGauge.longValue()) {
                        threshold = this.add(threshold, this.offset);
                    }
                    object.setThreshold((Object)threshold);
                    object.setNotAlreadyNotified(this.THRESHOLD_EXCEEDED_NOTIFIED);
                }
            }
        } else if (derivedGauge.longValue() < threshold.longValue() && this.offset.longValue() == 0L) {
            object.setNotAlreadyNotified(this.THRESHOLD_EXCEEDED_NOTIFIED);
        }
        if (this.modulus.longValue() != 0L && number.longValue() >= this.modulus.longValue()) {
            object.setThreshold((Object)this.initThreshold);
            object.setAlreadyNotified(this.THRESHOLD_EXCEEDED_NOTIFIED);
        }
        object.setLastValue((Object)number);
    }

    Number getZero(Number value) {
        if (value instanceof Byte) {
            return new Byte(0);
        }
        if (value instanceof Integer) {
            return new Integer(0);
        }
        if (value instanceof Short) {
            return new Short(0);
        }
        return new Long(0L);
    }

    Number add(Number value1, Number value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)(value1.byteValue() + value2.byteValue()));
        }
        if (value1 instanceof Integer) {
            return new Integer(value1.intValue() + value2.intValue());
        }
        if (value1 instanceof Short) {
            return new Short((short)(value1.shortValue() + value2.shortValue()));
        }
        return new Long(value1.longValue() + value2.longValue());
    }

    Number sub(Number value1, Number value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)(value1.byteValue() - value2.byteValue()));
        }
        if (value1 instanceof Integer) {
            return new Integer(value1.intValue() - value2.intValue());
        }
        if (value1 instanceof Short) {
            return new Short((short)(value1.shortValue() - value2.shortValue()));
        }
        return new Long(value1.longValue() - value2.longValue());
    }

    void sendThresholdExceededNotification(ObservedObject object, Object value) {
        if (this.notify) {
            this.sendNotification(object, "jmx.monitor.counter.threshold", object.getDerivedGaugeTimeStamp(), "threshold exceeded", this.observedAttribute, value, object.getThreshold());
        }
    }

    void sendThresholdErrorNotification(ObservedObject object, Object value) {
        if (object.notAlreadyNotified(this.THRESHOLD_ERROR_NOTIFIED)) {
            this.sendNotification(object, "jmx.monitor.error.threshold", object.getDerivedGaugeTimeStamp(), "Threshold, offset or modulus not the correct type", this.observedAttribute, null, null);
        }
    }
}

