/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.login;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.AuthPermission;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.jboss.logging.Logger;

public class LoginContext {
    private static Logger log = Logger.getLogger((Class)(class$javax$security$auth$login$LoginContext == null ? (class$javax$security$auth$login$LoginContext = LoginContext.class$("javax.security.auth.login.LoginContext")) : class$javax$security$auth$login$LoginContext));
    private static final AuthPermission CREATE_LC_PERM = new AuthPermission("createLoginContext.*");
    private Subject subject;
    private CallbackHandler callbackHandler;
    AppConfigurationEntry[] configEntry;
    private State[] contextState;
    private boolean trace;
    static /* synthetic */ Class class$javax$security$auth$login$LoginContext;

    public LoginContext(String name) throws LoginException {
        this(name, null, null);
    }

    public LoginContext(String name, CallbackHandler callbackHandler) throws LoginException {
        this(name, null, callbackHandler);
    }

    public LoginContext(String name, Subject subject) throws LoginException {
        this(name, subject, null);
    }

    public LoginContext(String name, Subject subject, CallbackHandler callbackHandler) throws LoginException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(CREATE_LC_PERM);
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.trace = log.isTraceEnabled();
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                return Configuration.getConfiguration();
            }
        };
        Configuration config = (Configuration)AccessController.doPrivileged(action);
        this.configEntry = config.getAppConfigurationEntry(name);
        if (this.configEntry == null) {
            throw new LoginException("Failed to find login module config for name: " + name);
        }
        if (this.configEntry.length == 0) {
            throw new LoginException("No login modules found in config for name: " + name);
        }
    }

    public Subject getSubject() {
        return this.subject;
    }

    public void login() throws LoginException {
        boolean requiredLoginOk = true;
        boolean optionalLoginOk = false;
        int requiredCount = 0;
        int ignoreCount = 0;
        Throwable firstRequiredEx = null;
        Throwable firstOptionalEx = null;
        HashMap sharedState = new HashMap();
        Subject loginSubject = this.subject;
        if (loginSubject == null) {
            loginSubject = new Subject();
        }
        this.contextState = new State[this.configEntry.length];
        int e = 0;
        while (e < this.contextState.length) {
            try {
                this.contextState[e] = new State(loginSubject, sharedState, this.callbackHandler, this.configEntry[e]);
            }
            catch (Exception ex) {
                throw new LoginException("Failed to create LoginModule(" + this.configEntry[e].getLoginModuleName() + "), msg=" + ex.getMessage());
            }
            State state = this.contextState[e];
            state.initialize();
            if (state.isRequisite() || state.isRequired()) {
                ++requiredCount;
                if (state.initEx != null && firstRequiredEx == null) {
                    firstRequiredEx = state.initEx;
                }
            } else if (state.initEx != null && firstOptionalEx == null) {
                firstOptionalEx = state.initEx;
            }
            ++e;
        }
        int e2 = 0;
        while (e2 < this.contextState.length) {
            State state = this.contextState[e2];
            boolean thisLoginOk = false;
            if (state.initEx == null) {
                thisLoginOk = state.login();
                if (firstOptionalEx == null) {
                    firstOptionalEx = state.optionalException();
                }
                if (firstRequiredEx == null) {
                    firstRequiredEx = state.requiredException();
                }
                if (this.trace) {
                    log.trace((Object)("thisLoginOk=" + thisLoginOk + ", state=" + state));
                }
                if (thisLoginOk && state.loginEx == null && state.isSufficient()) {
                    optionalLoginOk = true;
                    break;
                }
                if (state.loginEx != null && state.isRequisite()) {
                    requiredLoginOk = false;
                    break;
                }
                if (thisLoginOk) {
                    if (state.isRequisite() || state.isRequired()) {
                        requiredLoginOk &= state.loginEx == null;
                    } else {
                        optionalLoginOk |= state.loginEx == null;
                    }
                } else {
                    ++ignoreCount;
                }
            } else if (state.isRequisite() || state.isRequired()) {
                requiredLoginOk = false;
            }
            ++e2;
        }
        boolean loginOk = requiredLoginOk;
        if (requiredCount == 0) {
            loginOk = optionalLoginOk;
        }
        if (this.trace) {
            log.trace((Object)("ignoreCount=" + ignoreCount + ", requiredCount=" + requiredCount + ", requiredLoginOk=" + requiredLoginOk + ", optionalLoginOk=" + optionalLoginOk + ", firstRequiredEx=" + firstRequiredEx + ", firstOptionalEx=" + firstOptionalEx));
        }
        int e3 = 0;
        while (e3 < this.contextState.length) {
            State state = this.contextState[e3];
            if (loginOk) {
                state.commit();
            } else {
                state.abort();
            }
            ++e3;
        }
        if (!loginOk) {
            if (firstRequiredEx != null) {
                if (firstRequiredEx instanceof LoginException) {
                    throw (LoginException)firstRequiredEx;
                }
                throw new LoginException("Login failed, msg=" + firstRequiredEx.getMessage());
            }
            if (firstOptionalEx != null) {
                if (firstOptionalEx instanceof LoginException) {
                    throw (LoginException)firstOptionalEx;
                }
                throw new LoginException("Login failed, msg=" + firstOptionalEx.getMessage());
            }
            if (ignoreCount == this.contextState.length) {
                throw new LoginException("Login failed, all modules ignored");
            }
        } else {
            this.subject = loginSubject;
        }
    }

    public void logout() throws LoginException {
        if (this.subject == null) {
            throw new LoginException("No non-null subject exists");
        }
        int e = 0;
        while (e < this.contextState.length) {
            State state = this.contextState[e];
            state.logout();
            ++e;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class State {
        private Subject subject;
        private CallbackHandler handler;
        private Map sharedMap;
        private AppConfigurationEntry entry;
        private LoginModule module;
        Throwable initEx;
        Throwable loginEx;

        State(Subject subject, Map sharedMap, CallbackHandler handler, AppConfigurationEntry entry) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            this.subject = subject;
            this.sharedMap = sharedMap;
            this.handler = handler;
            this.entry = entry;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> lmClass = cl.loadClass(entry.getLoginModuleName());
            this.module = (LoginModule)lmClass.newInstance();
        }

        Throwable requiredException() {
            Throwable t = this.loginEx;
            if (!this.isRequired() && !this.isRequisite()) {
                t = null;
            }
            return t;
        }

        Throwable optionalException() {
            Throwable t = this.loginEx;
            if (!this.isSufficient() && !this.isOptional()) {
                t = null;
            }
            return t;
        }

        boolean isRequired() {
            return this.entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
        }

        boolean isRequisite() {
            return this.entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
        }

        boolean isSufficient() {
            return this.entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
        }

        boolean isOptional() {
            return this.entry.getControlFlag() == AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
        }

        void initialize() {
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(this){
                private final /* synthetic */ State this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() throws Exception {
                    State.access$400(this.this$0).initialize(State.access$000(this.this$0), State.access$100(this.this$0), State.access$200(this.this$0), State.access$300(this.this$0).getOptions());
                    return null;
                }
            };
            try {
                AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                this.initEx = e.getException();
            }
            catch (Throwable t) {
                this.initEx = t;
            }
        }

        boolean login() throws LoginException {
            boolean loginOk = true;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(this){
                private final /* synthetic */ State this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() throws LoginException {
                    boolean ok = State.access$400(this.this$0).login();
                    return new Boolean(ok);
                }
            };
            try {
                Boolean ok = (Boolean)AccessController.doPrivileged(action);
                loginOk = ok;
            }
            catch (PrivilegedActionException e) {
                this.loginEx = e.getException();
            }
            catch (Throwable t) {
                this.loginEx = t;
            }
            return loginOk;
        }

        boolean commit() throws LoginException {
            boolean commitOk = true;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(this){
                private final /* synthetic */ State this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() throws LoginException {
                    boolean ok = State.access$400(this.this$0).commit();
                    return new Boolean(ok);
                }
            };
            try {
                Boolean ok = (Boolean)AccessController.doPrivileged(action);
                commitOk = ok;
            }
            catch (PrivilegedActionException e) {
                throw (LoginException)e.getException();
            }
            return commitOk;
        }

        boolean abort() throws LoginException {
            boolean abortOk = true;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(this){
                private final /* synthetic */ State this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() throws LoginException {
                    boolean ok = State.access$400(this.this$0).abort();
                    return new Boolean(ok);
                }
            };
            try {
                Boolean ok = (Boolean)AccessController.doPrivileged(action);
                abortOk = ok;
            }
            catch (PrivilegedActionException e) {
                throw (LoginException)e.getException();
            }
            return abortOk;
        }

        boolean logout() throws LoginException {
            boolean logoutOk = true;
            PrivilegedExceptionAction action = new PrivilegedExceptionAction(this){
                private final /* synthetic */ State this$0;
                {
                    this.this$0 = this$0;
                }

                public Object run() throws LoginException {
                    boolean ok = State.access$400(this.this$0).logout();
                    return new Boolean(ok);
                }
            };
            try {
                Boolean ok = (Boolean)AccessController.doPrivileged(action);
                logoutOk = ok;
            }
            catch (PrivilegedActionException e) {
                throw (LoginException)e.getException();
            }
            return logoutOk;
        }

        public String toString() {
            StringBuffer tmp = new StringBuffer(this.entry.getLoginModuleName());
            tmp.append('{');
            tmp.append("controlFlag: ");
            tmp.append(this.entry.getControlFlag());
            tmp.append(", options: ");
            tmp.append(this.entry.getOptions());
            tmp.append(", initEx: ");
            tmp.append(this.initEx);
            tmp.append(", loginEx: ");
            tmp.append(this.loginEx);
            tmp.append('}');
            return tmp.toString();
        }

        static /* synthetic */ Subject access$000(State x0) {
            return x0.subject;
        }

        static /* synthetic */ CallbackHandler access$100(State x0) {
            return x0.handler;
        }

        static /* synthetic */ Map access$200(State x0) {
            return x0.sharedMap;
        }

        static /* synthetic */ AppConfigurationEntry access$300(State x0) {
            return x0.entry;
        }

        static /* synthetic */ LoginModule access$400(State x0) {
            return x0.module;
        }
    }
}

