/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumberValueExp;
import javax.management.ObjectName;
import javax.management.QueryExpSupport;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BetweenQueryExp
extends QueryExpSupport {
    ValueExp test;
    ValueExp lower;
    ValueExp upper;

    public BetweenQueryExp(ValueExp test, ValueExp lower, ValueExp upper) {
        this.test = test;
        this.lower = lower;
        this.upper = upper;
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp calcTest = this.test.apply(name);
        ValueExp calcLower = this.lower.apply(name);
        ValueExp calcUpper = this.upper.apply(name);
        if (calcTest instanceof NumberValueExp) {
            double valueTest = ((NumberValueExp)calcTest).getDoubleValue();
            double valueLower = ((NumberValueExp)calcLower).getDoubleValue();
            double valueUpper = ((NumberValueExp)calcUpper).getDoubleValue();
            return valueLower <= valueTest && valueTest <= valueUpper;
        }
        if (calcTest instanceof StringValueExp) {
            String valueTest = ((StringValueExp)calcTest).toString();
            String valueLower = ((StringValueExp)calcLower).toString();
            String valueUpper = ((StringValueExp)calcUpper).toString();
            return valueLower.compareTo(valueTest) <= 0 && valueUpper.compareTo(valueTest) >= 0;
        }
        return false;
    }

    public String toString() {
        return new String("(" + this.lower.toString() + ") <= (" + this.test.toString() + ") <= (" + this.upper.toString()) + ")";
    }
}

