/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumberValueExp;
import javax.management.ObjectName;
import javax.management.QueryExpSupport;
import javax.management.SingleValueExpSupport;
import javax.management.StringValueExp;
import javax.management.ValueExp;

class BinaryComparisonQueryExp
extends QueryExpSupport {
    int operation;
    ValueExp first;
    ValueExp second;

    public BinaryComparisonQueryExp(int operation, ValueExp first, ValueExp second) {
        this.operation = operation;
        this.first = first;
        this.second = second;
    }

    public boolean apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp testFirst = this.first.apply(name);
        ValueExp testSecond = this.second.apply(name);
        if (testFirst instanceof NumberValueExp) {
            switch (this.operation) {
                case 4: {
                    return ((NumberValueExp)testFirst).getDoubleValue() > ((NumberValueExp)testSecond).getDoubleValue();
                }
                case 3: {
                    return ((NumberValueExp)testFirst).getDoubleValue() >= ((NumberValueExp)testSecond).getDoubleValue();
                }
                case 6: {
                    return ((NumberValueExp)testFirst).getDoubleValue() < ((NumberValueExp)testSecond).getDoubleValue();
                }
                case 5: {
                    return ((NumberValueExp)testFirst).getDoubleValue() <= ((NumberValueExp)testSecond).getDoubleValue();
                }
                case 2: {
                    return ((NumberValueExp)testFirst).getDoubleValue() == ((NumberValueExp)testSecond).getDoubleValue();
                }
            }
        } else {
            if (testFirst instanceof StringValueExp) {
                switch (this.operation) {
                    case 4: {
                        return ((StringValueExp)testFirst).toString().compareTo(((StringValueExp)testSecond).toString()) > 0;
                    }
                    case 3: {
                        return ((StringValueExp)testFirst).toString().compareTo(((StringValueExp)testSecond).toString()) >= 0;
                    }
                    case 6: {
                        return ((StringValueExp)testFirst).toString().compareTo(((StringValueExp)testSecond).toString()) < 0;
                    }
                    case 5: {
                        return ((StringValueExp)testFirst).toString().compareTo(((StringValueExp)testSecond).toString()) <= 0;
                    }
                    case 2: {
                        return ((StringValueExp)testFirst).toString().compareTo(((StringValueExp)testSecond).toString()) == 0;
                    }
                }
                throw new BadStringOperationException("TODO");
            }
            if (testFirst instanceof SingleValueExpSupport) {
                switch (this.operation) {
                    case 2: {
                        return ((SingleValueExpSupport)testFirst).getValue().equals(((SingleValueExpSupport)testSecond).getValue());
                    }
                }
            }
        }
        throw new BadBinaryOpValueExpException(testFirst);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(this.first);
        buffer.append(")");
        switch (this.operation) {
            case 4: {
                buffer.append(" > ");
                break;
            }
            case 3: {
                buffer.append(" >= ");
                break;
            }
            case 6: {
                buffer.append(" < ");
                break;
            }
            case 5: {
                buffer.append(" <= ");
                break;
            }
            case 2: {
                buffer.append(" == ");
            }
        }
        buffer.append("(");
        buffer.append(this.second);
        buffer.append(")");
        return buffer.toString();
    }
}

