/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import javax.management.BadAttributeValueExpException;
import javax.management.BadBinaryOpValueExpException;
import javax.management.BadStringOperationException;
import javax.management.InvalidApplicationException;
import javax.management.NumberValueExp;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.StringValueExp;
import javax.management.ValueExp;
import javax.management.ValueExpSupport;

class BinaryOpValueExp
extends ValueExpSupport {
    int operation;
    ValueExp first;
    ValueExp second;

    public BinaryOpValueExp(int operation, ValueExp first, ValueExp second) {
        this.operation = operation;
        this.first = first;
        this.second = second;
    }

    public ValueExp apply(ObjectName name) throws BadStringOperationException, BadBinaryOpValueExpException, BadAttributeValueExpException, InvalidApplicationException {
        ValueExp testFirst = this.first.apply(name);
        ValueExp testSecond = this.second.apply(name);
        if (testFirst instanceof NumberValueExp) {
            if (((NumberValueExp)testFirst).isInteger()) {
                switch (this.operation) {
                    case 8: {
                        return Query.value(((NumberValueExp)testFirst).getLongValue() + ((NumberValueExp)testSecond).getLongValue());
                    }
                    case 7: {
                        return Query.value(((NumberValueExp)testFirst).getLongValue() - ((NumberValueExp)testSecond).getLongValue());
                    }
                    case 9: {
                        return Query.value(((NumberValueExp)testFirst).getLongValue() * ((NumberValueExp)testSecond).getLongValue());
                    }
                    case 1: {
                        return Query.value(((NumberValueExp)testFirst).getLongValue() / ((NumberValueExp)testSecond).getLongValue());
                    }
                }
            } else {
                switch (this.operation) {
                    case 8: {
                        return Query.value(((NumberValueExp)testFirst).getDoubleValue() + ((NumberValueExp)testSecond).getDoubleValue());
                    }
                    case 7: {
                        return Query.value(((NumberValueExp)testFirst).getDoubleValue() - ((NumberValueExp)testSecond).getDoubleValue());
                    }
                    case 9: {
                        return Query.value(((NumberValueExp)testFirst).getDoubleValue() * ((NumberValueExp)testSecond).getDoubleValue());
                    }
                    case 1: {
                        return Query.value(((NumberValueExp)testFirst).getDoubleValue() / ((NumberValueExp)testSecond).getDoubleValue());
                    }
                }
            }
        } else if (testFirst instanceof StringValueExp) {
            switch (this.operation) {
                case 8: {
                    return Query.value(new String(((StringValueExp)testFirst).toString() + ((StringValueExp)testSecond).toString()));
                }
            }
            throw new BadStringOperationException("TODO");
        }
        throw new BadBinaryOpValueExpException(testFirst);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("(");
        buffer.append(this.first);
        buffer.append(")");
        switch (this.operation) {
            case 8: {
                buffer.append(" + ");
                break;
            }
            case 7: {
                buffer.append(" - ");
                break;
            }
            case 9: {
                buffer.append(" * ");
                break;
            }
            case 1: {
                buffer.append(" / ");
            }
        }
        buffer.append("(");
        buffer.append(this.second);
        buffer.append(")");
        return buffer.toString();
    }
}

