/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.IntrospectionException;
import javax.management.MBeanFeatureInfo;

public class MBeanAttributeInfo
extends MBeanFeatureInfo
implements Serializable,
Cloneable {
    private String type = null;
    private boolean isReadable = false;
    private boolean isWritable = false;
    private boolean isIs = false;

    public MBeanAttributeInfo(String name, String type, String description, boolean isReadable, boolean isWritable, boolean isIs) {
        super(name, description);
        this.type = type;
        this.isReadable = isReadable;
        this.isWritable = isWritable;
        this.isIs = isIs;
    }

    public MBeanAttributeInfo(String name, String description, Method getter, Method setter) throws IntrospectionException {
        super(name, description);
        if (getter != null) {
            if (getter.getParameterTypes().length != 0) {
                throw new IntrospectionException("Expecting getter method to be of the form 'AttributeType getAttributeName()': found getter with " + getter.getParameterTypes().length + " parameters.");
            }
            if (getter.getReturnType() == Void.TYPE) {
                throw new IntrospectionException("Expecting getter method to be of the form 'AttributeType getAttributeName()': found getter with void return type.");
            }
            this.isReadable = true;
            if (getter.getName().startsWith("is")) {
                this.isIs = true;
            }
            this.type = getter.getReturnType().getName();
        }
        if (setter != null) {
            if (setter.getParameterTypes().length != 1) {
                throw new IntrospectionException("Expecting the setter method to be of the form 'void setAttributeName(AttributeType value)': found setter with " + setter.getParameterTypes().length + " parameters.");
            }
            if (setter.getReturnType() != Void.TYPE) {
                throw new IntrospectionException("Expecting the setter method to be of the form 'void setAttributeName(AttributeType value)': found setter with " + setter.getReturnType() + " return type.");
            }
            this.isWritable = true;
            if (this.type == null) {
                try {
                    this.type = setter.getParameterTypes()[0].getName();
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    throw new IntrospectionException("Attribute setter is lacking type: " + name);
                }
            }
            if (!this.type.equals(setter.getParameterTypes()[0].getName())) {
                throw new IntrospectionException("Attribute type mismatch: " + name);
            }
        }
    }

    public String getType() {
        return this.type;
    }

    public boolean isReadable() {
        return this.isReadable;
    }

    public boolean isWritable() {
        return this.isWritable;
    }

    public boolean isIs() {
        return this.isIs;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        MBeanAttributeInfo clone = (MBeanAttributeInfo)super.clone();
        clone.type = this.type;
        clone.isReadable = this.isReadable;
        clone.isWritable = this.isWritable;
        clone.isIs = this.isIs;
        return clone;
    }
}

