/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBeanServerFactory {
    private static Map serverMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    public static void releaseMBeanServer(MBeanServer mbeanServer) {
        try {
            String agentID = (String)mbeanServer.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
            Object server = serverMap.remove(agentID);
            if (server == null) {
                throw new IllegalArgumentException("MBean server reference not found.");
            }
        }
        catch (MalformedObjectNameException e) {
            throw new Error(e.toString());
        }
        catch (JMException e) {
            throw new Error("Cannot retrieve AgentID: " + e.toString());
        }
    }

    public static MBeanServer createMBeanServer() {
        return MBeanServerFactory.createMBeanServer("DefaultDomain");
    }

    public static MBeanServer createMBeanServer(String domain) {
        return MBeanServerFactory.createMBeanServer(domain, true);
    }

    public static MBeanServer newMBeanServer() {
        return MBeanServerFactory.newMBeanServer("DefaultDomain");
    }

    public static MBeanServer newMBeanServer(String domain) {
        return MBeanServerFactory.createMBeanServer(domain, false);
    }

    public static ArrayList findMBeanServer(String agentId) {
        if (agentId != null) {
            ArrayList list = new ArrayList(1);
            Object server = serverMap.get(agentId);
            if (server != null) {
                list.add(server);
            }
            return list;
        }
        return new ArrayList(serverMap.values());
    }

    private static MBeanServer createMBeanServer(String defaultDomain, boolean registerServer) {
        String serverClass = System.getProperty("jbossmx.mbean.server.class", "org.jboss.mx.server.MBeanServerImpl");
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(serverClass);
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = MBeanServerFactory.class$("java.lang.String")) : class$java$lang$String);
            MBeanServer server = (MBeanServer)constructor.newInstance(defaultDomain);
            if (registerServer) {
                String agentID = (String)server.getAttribute(new ObjectName("JMImplementation:type=MBeanServerDelegate"), "MBeanServerId");
                serverMap.put(agentID, server);
            }
            return server;
        }
        catch (MalformedObjectNameException e) {
            throw new Error(e.toString());
        }
        catch (JMException e) {
            throw new Error("Cannot retrieve AgentID: " + e.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("The MBean server implementation class " + serverClass + " was not found: " + e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("The MBean server implementation class " + serverClass + " must contain a default domain string constructor: " + serverClass + "(java.langString defaultDomain)");
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Cannot instantiate class " + serverClass + ": " + e.toString());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Unable to create the MBean server instance. Illegal access to class " + serverClass + " constructor: " + e.toString());
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Unable to create the MBean server instance. Class " + serverClass + " has raised an exception in constructor: " + e.getTargetException().toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

