/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import java.util.EventObject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class Notification
extends EventObject {
    private String type = null;
    private long sequenceNumber = 0L;
    private String message = null;
    private long timeStamp = System.currentTimeMillis();
    private Object userData = null;
    private Object mySource = null;

    public Notification(String type, Object source, long sequenceNumber) {
        super(source);
        this.mySource = source;
        this.type = type;
        this.sequenceNumber = sequenceNumber;
        this.timeStamp = System.currentTimeMillis();
    }

    public Notification(String type, Object source, long sequenceNumber, String message) {
        this(type, source, sequenceNumber);
        this.message = message;
        this.timeStamp = System.currentTimeMillis();
    }

    public Notification(String type, Object source, long sequenceNumber, long timeStamp) {
        this(type, source, sequenceNumber);
        this.timeStamp = timeStamp;
    }

    public Notification(String type, Object source, long sequenceNumber, long timeStamp, String message) {
        this(type, source, sequenceNumber, timeStamp);
        this.message = message;
    }

    public Object getSource() {
        return this.mySource;
    }

    public void setSource(Object source) throws IllegalArgumentException {
        if (source instanceof String) {
            try {
                this.source = new ObjectName((String)source);
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("malformed object name: " + source);
            }
        } else if (source instanceof ObjectName) {
            this.source = source;
        } else {
            throw new IllegalArgumentException("Notification source must be an object name");
        }
        this.mySource = this.source;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }

    public String getType() {
        return this.type;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }
}

