/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;

public class DescriptorSupport
implements Descriptor,
Cloneable,
Serializable {
    public String currClass;
    private Map fieldMap = Collections.synchronizedMap(new HashMap(20));

    public DescriptorSupport() {
    }

    public DescriptorSupport(int initialSize) throws MBeanException {
        if (initialSize <= 0) {
            throw new RuntimeOperationsException(new IllegalArgumentException("initialSize <= 0"));
        }
        this.fieldMap = Collections.synchronizedMap(new HashMap(initialSize));
    }

    public DescriptorSupport(DescriptorSupport descriptor) {
        if (descriptor != null) {
            this.setFields(descriptor.getFieldNames(), descriptor.getFieldValues(descriptor.getFieldNames()));
        }
    }

    public DescriptorSupport(String[] fieldNames, Object[] fieldValues) throws RuntimeOperationsException {
        if (fieldNames == null && fieldValues == null) {
            return;
        }
        this.setFields(fieldNames, fieldValues);
    }

    public DescriptorSupport(String[] fields) {
        int i = 0;
        while (i < fields.length) {
            int index = fields[i].indexOf(61);
            if (index != -1) {
                String field = fields[i].substring(0, index);
                String value = fields[i].substring(index + 1, fields[i].length());
                this.fieldMap.put(field, value);
            }
            ++i;
        }
    }

    public Object getFieldValue(String inFieldName) {
        return this.fieldMap.get(inFieldName);
    }

    public void setField(String inFieldName, Object fieldValue) {
        this.fieldMap.put(inFieldName, fieldValue);
    }

    public String[] getFields() {
        String[] fieldStrings = new String[this.fieldMap.size()];
        Iterator it = this.fieldMap.keySet().iterator();
        int i = 0;
        while (i < this.fieldMap.size()) {
            String key = (String)it.next();
            fieldStrings[i] = key + "=" + this.fieldMap.get(key);
            ++i;
        }
        return fieldStrings;
    }

    public String[] getFieldNames() {
        return this.fieldMap.keySet().toArray(new String[0]);
    }

    public Object[] getFieldValues(String[] fieldNames) {
        Object[] values = new Object[fieldNames.length];
        int i = 0;
        while (i < fieldNames.length) {
            values[i] = this.fieldMap.get(fieldNames[i]);
            ++i;
        }
        return values;
    }

    public void setFields(String[] fieldNames, Object[] fieldValues) {
        if (fieldNames == null || fieldValues == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("fieldNames or fieldValues was null."));
        }
        if (fieldNames.length == 0 || fieldValues.length == 0) {
            return;
        }
        if (fieldNames.length != fieldValues.length) {
            throw new RuntimeOperationsException(new IllegalArgumentException("fieldNames and fieldValues array size must match."));
        }
        int i = 0;
        while (i < fieldNames.length) {
            String name = fieldNames[i];
            if (name != null) {
                this.fieldMap.put(name, fieldValues[i]);
            }
            ++i;
        }
    }

    public synchronized Object clone() {
        try {
            DescriptorSupport clone = (DescriptorSupport)super.clone();
            clone.fieldMap = Collections.synchronizedMap(new HashMap(this.fieldMap));
            clone.currClass = this.currClass;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeOperationsException(new RuntimeException(e.getMessage()), e.toString());
        }
    }

    public void removeField(String fieldName) {
        this.fieldMap.remove(fieldName);
    }

    public boolean isValid() throws RuntimeOperationsException {
        return true;
    }

    public String toString() {
        String[] names = this.getFieldNames();
        Object[] values = this.getFieldValues(names);
        if (names.length == 0) {
            return "<empty descriptor>";
        }
        StringBuffer sbuf = new StringBuffer(500);
        int i = 0;
        while (i < values.length) {
            sbuf.append(names[i]);
            sbuf.append("=");
            sbuf.append(values[i]);
            sbuf.append(",");
            ++i;
        }
        sbuf.deleteCharAt(sbuf.length() - 1);
        return sbuf.toString();
    }
}

