/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class ModelMBeanInfoSupport
extends MBeanInfo
implements ModelMBeanInfo,
Serializable {
    private Descriptor mbeanDescriptor = null;

    public ModelMBeanInfoSupport(ModelMBeanInfo mbi) {
        super(mbi.getClassName(), mbi.getDescription(), mbi.getAttributes(), mbi.getConstructors(), mbi.getOperations(), mbi.getNotifications());
        try {
            this.setMBeanDescriptor(mbi.getMBeanDescriptor());
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications) {
        super(className, description, null == attributes ? new ModelMBeanAttributeInfo[]{} : attributes, null == constructors ? new ModelMBeanConstructorInfo[]{} : constructors, null == operations ? new ModelMBeanOperationInfo[]{} : operations, null == notifications ? new ModelMBeanNotificationInfo[]{} : notifications);
        try {
            this.setMBeanDescriptor(this.createDefaultDescriptor(className));
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public ModelMBeanInfoSupport(String className, String description, ModelMBeanAttributeInfo[] attributes, ModelMBeanConstructorInfo[] constructors, ModelMBeanOperationInfo[] operations, ModelMBeanNotificationInfo[] notifications, Descriptor mbeandescriptor) {
        this(className, description, attributes, constructors, operations, notifications);
        try {
            this.setMBeanDescriptor(mbeandescriptor);
        }
        catch (MBeanException e) {
            throw new IllegalArgumentException(e.toString());
        }
    }

    public Descriptor[] getDescriptors(String descrType) throws MBeanException {
        if (descrType == null) {
            ArrayList<Descriptor> list = new ArrayList<Descriptor>(100);
            list.add(this.mbeanDescriptor);
            list.addAll(this.getAttributeDescriptors().values());
            list.addAll(this.getOperationDescriptors().values());
            list.addAll(this.getNotificationDescriptors().values());
            list.addAll(this.getConstructorDescriptors().values());
            return list.toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("MBean")) {
            return new Descriptor[]{this.mbeanDescriptor};
        }
        if (descrType.equalsIgnoreCase("attribute")) {
            return this.getAttributeDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("operation")) {
            return this.getOperationDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("notification")) {
            return this.getNotificationDescriptors().values().toArray(new Descriptor[0]);
        }
        if (descrType.equalsIgnoreCase("constructor")) {
            return this.getConstructorDescriptors().values().toArray(new Descriptor[0]);
        }
        throw new IllegalArgumentException("unknown descriptor type: " + descrType);
    }

    public void setDescriptors(Descriptor[] inDescriptors) throws MBeanException {
        int i = 0;
        while (i < inDescriptors.length) {
            if (inDescriptors[i] != null && inDescriptors[i].isValid()) {
                this.setDescriptor(inDescriptors[i], (String)inDescriptors[i].getFieldValue("descriptorType"));
            }
            ++i;
        }
    }

    public Descriptor getDescriptor(String descrName) throws MBeanException {
        if (descrName.equals(this.mbeanDescriptor.getFieldValue("name"))) {
            return this.mbeanDescriptor;
        }
        Descriptor descr = null;
        descr = (Descriptor)this.getAttributeDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getOperationDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getNotificationDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        descr = (Descriptor)this.getConstructorDescriptors().get(descrName);
        if (descr != null) {
            return descr;
        }
        return null;
    }

    public Descriptor getDescriptor(String descrName, String descrType) throws MBeanException {
        if (descrType == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("null descriptor type"));
        }
        if (descrType.equalsIgnoreCase("MBean")) {
            return this.mbeanDescriptor;
        }
        if (descrType.equalsIgnoreCase("attribute")) {
            return (Descriptor)this.getAttributeDescriptors().get(descrName);
        }
        if (descrType.equalsIgnoreCase("operation")) {
            return (Descriptor)this.getOperationDescriptors().get(descrName);
        }
        if (descrType.equalsIgnoreCase("constructor")) {
            return (Descriptor)this.getConstructorDescriptors().get(descrName);
        }
        if (descrType.equalsIgnoreCase("notification")) {
            return (Descriptor)this.getNotificationDescriptors().get(descrName);
        }
        throw new IllegalArgumentException("unknown descriptor type: " + descrType);
    }

    public void setDescriptor(Descriptor descr, String descrType) throws MBeanException {
        if (descrType == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("null descriptor type"));
        }
        if (descrType.equalsIgnoreCase("MBean")) {
            this.setMBeanDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("attribute")) {
            ModelMBeanAttributeInfo info = this.getAttribute((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("operation")) {
            ModelMBeanOperationInfo info = this.getOperation((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("constructor")) {
            ModelMBeanConstructorInfo info = this.getConstructor((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else if (descrType.equalsIgnoreCase("notification")) {
            ModelMBeanNotificationInfo info = this.getNotification((String)descr.getFieldValue("name"));
            info.setDescriptor(descr);
        } else {
            throw new IllegalArgumentException("unknown descriptor type: " + descrType);
        }
    }

    public ModelMBeanAttributeInfo getAttribute(String inName) throws MBeanException {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].getName().equals(inName)) {
                return (ModelMBeanAttributeInfo)this.attributes[i];
            }
            ++i;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain attribute " + inName));
    }

    public ModelMBeanOperationInfo getOperation(String inName) throws MBeanException {
        int i = 0;
        while (i < this.operations.length) {
            if (this.operations[i].getName().equals(inName)) {
                return (ModelMBeanOperationInfo)this.operations[i];
            }
            ++i;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain operation " + inName));
    }

    public ModelMBeanConstructorInfo getConstructor(String inName) throws MBeanException {
        int i = 0;
        while (i < this.constructors.length) {
            if (this.constructors[i].getName().equals(inName)) {
                return (ModelMBeanConstructorInfo)this.constructors[i];
            }
            ++i;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain constructor " + inName));
    }

    public ModelMBeanNotificationInfo getNotification(String inName) throws MBeanException {
        int i = 0;
        while (i < this.notifications.length) {
            if (this.notifications[i].getName().equals(inName)) {
                return (ModelMBeanNotificationInfo)this.notifications[i];
            }
            ++i;
        }
        throw new RuntimeOperationsException(new IllegalArgumentException("MBean does not contain notification " + inName));
    }

    public MBeanAttributeInfo[] getAttributes() {
        return super.getAttributes();
    }

    public MBeanOperationInfo[] getOperations() {
        return super.getOperations();
    }

    public MBeanConstructorInfo[] getConstructors() {
        return super.getConstructors();
    }

    public MBeanNotificationInfo[] getNotifications() {
        return super.getNotifications();
    }

    public Descriptor getMBeanDescriptor() throws MBeanException {
        return this.mbeanDescriptor;
    }

    public void setMBeanDescriptor(Descriptor inMBeanDescriptor) throws MBeanException {
        Descriptor descr = (Descriptor)inMBeanDescriptor.clone();
        this.addDefaultMBeanDescriptorFields(descr);
        this.mbeanDescriptor = descr;
    }

    public Object clone() {
        try {
            ModelMBeanInfoSupport clone = (ModelMBeanInfoSupport)super.clone();
            clone.mbeanDescriptor = (Descriptor)this.mbeanDescriptor.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private void addDefaultMBeanDescriptorFields(Descriptor descr) {
        if (descr.getFieldValue("name") == null || descr.getFieldValue("name").equals("")) {
            descr.setField("name", this.className);
        }
        if (descr.getFieldValue("descriptorType") == null) {
            descr.setField("descriptorType", "MBean");
        }
        if (!((String)descr.getFieldValue("descriptorType")).equalsIgnoreCase("MBean")) {
            descr.setField("descriptorType", "MBean");
        }
        if (descr.getFieldValue("displayName") == null) {
            descr.setField("displayName", this.className);
        }
        if (descr.getFieldValue("persistPolicy") == null) {
            descr.setField("persistPolicy", "Never");
        }
        if (descr.getFieldValue("log") == null) {
            descr.setField("log", "F");
        }
        if (descr.getFieldValue("export") == null) {
            descr.setField("export", "F");
        }
        if (descr.getFieldValue("visibility") == null) {
            descr.setField("visibility", "1");
        }
    }

    private Descriptor createDefaultDescriptor(String className) {
        return new DescriptorSupport(new String[]{"name=" + className, "descriptorType=MBean", "displayName=" + className, "persistPolicy=Never", "log=F", "export=F", "visibility=1"});
    }

    private Map getAttributeDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        int i = 0;
        while (i < this.attributes.length) {
            map.put(this.attributes[i].getName(), ((ModelMBeanAttributeInfo)this.attributes[i]).getDescriptor());
            ++i;
        }
        return map;
    }

    private Map getOperationDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        int i = 0;
        while (i < this.operations.length) {
            map.put(this.operations[i].getName(), ((ModelMBeanOperationInfo)this.operations[i]).getDescriptor());
            ++i;
        }
        return map;
    }

    private Map getConstructorDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        int i = 0;
        while (i < this.constructors.length) {
            map.put(this.constructors[i].getName(), ((ModelMBeanConstructorInfo)this.constructors[i]).getDescriptor());
            ++i;
        }
        return map;
    }

    private Map getNotificationDescriptors() {
        HashMap<String, Descriptor> map = new HashMap<String, Descriptor>();
        int i = 0;
        while (i < this.notifications.length) {
            map.put(this.notifications[i].getName(), ((ModelMBeanNotificationInfo)this.notifications[i]).getDescriptor());
            ++i;
        }
        return map;
    }
}

