/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.DescriptorAccess;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.modelmbean.DescriptorSupport;

public class ModelMBeanOperationInfo
extends MBeanOperationInfo
implements DescriptorAccess,
Cloneable {
    private Descriptor descriptor = null;

    public ModelMBeanOperationInfo(String description, Method operationMethod) {
        super(description, operationMethod);
        this.setDescriptor(this.createDefaultDescriptor());
    }

    public ModelMBeanOperationInfo(String description, Method operationMethod, Descriptor descriptor) {
        this(description, operationMethod);
        if (descriptor == null || !descriptor.isValid()) {
            this.setDescriptor(this.createDefaultDescriptor());
        } else {
            this.setDescriptor(descriptor);
        }
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact) {
        super(name, description, signature, type, impact);
        this.setDescriptor(this.createDefaultDescriptor());
    }

    public ModelMBeanOperationInfo(String name, String description, MBeanParameterInfo[] signature, String type, int impact, Descriptor descriptor) {
        this(name, description, signature, type, impact);
        if (descriptor == null || !descriptor.isValid()) {
            this.setDescriptor(this.createDefaultDescriptor());
        } else {
            this.setDescriptor(descriptor);
        }
    }

    public ModelMBeanOperationInfo(ModelMBeanOperationInfo info) {
        this(info.getName(), info.getDescription(), info.getSignature(), info.getReturnType(), info.getImpact(), info.getDescriptor());
    }

    public Descriptor getDescriptor() {
        return (Descriptor)this.descriptor.clone();
    }

    public void setDescriptor(Descriptor inDescriptor) {
        if (inDescriptor == null) {
            inDescriptor = this.createDefaultDescriptor();
        }
        if (!inDescriptor.isValid()) {
            throw new IllegalArgumentException("Invalid descriptor.");
        }
        this.descriptor = inDescriptor;
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        ModelMBeanOperationInfo clone = (ModelMBeanOperationInfo)super.clone();
        clone.descriptor = (Descriptor)this.descriptor.clone();
        return clone;
    }

    public String toString() {
        return "ModelMBeanOperationInfo[" + this.getReturnType() + " " + this.getName() + this.getSignatureString() + ",Impact=" + this.getImpactString() + ",Descriptor(" + this.getDescriptor() + ")]";
    }

    private String getSignatureString() {
        StringBuffer sbuf = new StringBuffer(400);
        sbuf.append("(");
        MBeanParameterInfo[] sign = this.getSignature();
        if (sign.length > 0) {
            int i = 0;
            while (i < sign.length) {
                sbuf.append(sign[i].getType());
                sbuf.append(" ");
                sbuf.append(sign[i].getName());
                sbuf.append(",");
                ++i;
            }
            sbuf.delete(sbuf.length() - 1, sbuf.length());
        }
        sbuf.append(")");
        return sbuf.toString();
    }

    private String getImpactString() {
        int impact = this.getImpact();
        if (impact == 1) {
            return "ACTION";
        }
        if (impact == 0) {
            return "INFO";
        }
        if (impact == 2) {
            return "ACTION_INFO";
        }
        return "UNKNOWN";
    }

    private Descriptor createDefaultDescriptor() {
        DescriptorSupport descr = new DescriptorSupport();
        descr.setField("name", super.getName());
        descr.setField("descriptorType", "operation");
        return descr;
    }
}

