/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.monitor.GaugeMonitorMBean;
import javax.management.monitor.Monitor;

public class GaugeMonitor
extends Monitor
implements GaugeMonitorMBean {
    int THRESHOLD_HIGH_EXCEEDED_NOTIFIED = 16;
    int THRESHOLD_LOW_EXCEEDED_NOTIFIED = 32;
    int THRESHOLD_ERROR_NOTIFIED = 64;
    private Number derivedGauge = new Integer(0);
    private Number lastValue = null;
    private long derivedGaugeTimeStamp = 0L;
    boolean differenceMode = false;
    Number highThreshold = new Integer(0);
    Number lowThreshold = new Integer(0);
    boolean notifyHigh = false;
    boolean notifyLow = false;

    public GaugeMonitor() {
        this.dbgTag = "GaugeMonitor";
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[1];
        String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.error.threshold", "jmx.monitor.gauge.high", "jmx.monitor.gauge.low"};
        result[0] = new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the Gauge Monitor Service MBean");
        return result;
    }

    public Number getDerivedGauge() {
        return this.derivedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimeStamp;
    }

    public boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public void setDifferenceMode(boolean value) {
        this.differenceMode = value;
    }

    public boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public void setNotifyHigh(boolean value) {
        this.notifyHigh = value;
    }

    public boolean getNotifyLow() {
        return this.notifyLow;
    }

    public void setNotifyLow(boolean value) {
        this.notifyLow = value;
    }

    public Number getHighThreshold() {
        return this.highThreshold;
    }

    public Number getLowThreshold() {
        return this.lowThreshold;
    }

    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null) {
            throw new IllegalArgumentException("Null high threshold");
        }
        if (lowValue == null) {
            throw new IllegalArgumentException("Null low threshold");
        }
        if (highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException("High and low different types");
        }
        if (highValue.doubleValue() < lowValue.doubleValue()) {
            throw new IllegalArgumentException("High less than low threshold");
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
        this.alreadyNotified = 0;
    }

    public synchronized void start() {
        this.lastValue = null;
        this.derivedGauge = new Integer(0);
        this.derivedGaugeTimeStamp = System.currentTimeMillis();
        super.start();
    }

    void monitor(MBeanAttributeInfo attributeInfo, Object value) throws Exception {
        if (!(value instanceof Number)) {
            this.sendAttributeTypeErrorNotification("Attribute is not a number");
            return;
        }
        if (this.highThreshold.getClass() != value.getClass() || this.lowThreshold.getClass() != value.getClass()) {
            this.sendThresholdErrorNotification(value);
            return;
        }
        Number number = (Number)value;
        this.derivedGauge = this.differenceMode ? (Number)(this.lastValue == null ? (Number)this.getZero(number) : (Number)this.sub(number, this.lastValue)) : (Number)number;
        this.derivedGaugeTimeStamp = System.currentTimeMillis();
        if (this.derivedGauge.doubleValue() <= this.lowThreshold.doubleValue() && (this.alreadyNotified & this.THRESHOLD_LOW_EXCEEDED_NOTIFIED) == 0) {
            this.alreadyNotified &= ~this.THRESHOLD_HIGH_EXCEEDED_NOTIFIED;
            this.sendThresholdLowExceededNotification(this.derivedGauge);
            this.alreadyNotified |= this.THRESHOLD_LOW_EXCEEDED_NOTIFIED;
        }
        if (this.derivedGauge.doubleValue() >= this.highThreshold.doubleValue() && (this.alreadyNotified & this.THRESHOLD_HIGH_EXCEEDED_NOTIFIED) == 0) {
            this.alreadyNotified &= ~this.THRESHOLD_LOW_EXCEEDED_NOTIFIED;
            this.sendThresholdHighExceededNotification(this.derivedGauge);
            this.alreadyNotified |= this.THRESHOLD_HIGH_EXCEEDED_NOTIFIED;
        }
        this.lastValue = number;
    }

    Number getZero(Number value) {
        if (value instanceof Byte) {
            return new Byte(0);
        }
        if (value instanceof Integer) {
            return new Integer(0);
        }
        if (value instanceof Long) {
            return new Long(0L);
        }
        if (value instanceof Short) {
            return new Short(0);
        }
        if (value instanceof Float) {
            return new Float(0.0f);
        }
        return new Double(0.0);
    }

    Number sub(Number value1, Number value2) {
        if (value1 instanceof Byte) {
            return new Byte((byte)(value1.byteValue() - value2.byteValue()));
        }
        if (value1 instanceof Integer) {
            return new Integer(value1.intValue() - value2.intValue());
        }
        if (value1 instanceof Long) {
            return new Long(value1.longValue() - value2.longValue());
        }
        if (value1 instanceof Short) {
            return new Short((short)(value1.shortValue() - value2.shortValue()));
        }
        if (value1 instanceof Float) {
            return new Float(value1.floatValue() - value2.floatValue());
        }
        return new Double(value1.doubleValue() - value2.doubleValue());
    }

    void sendThresholdLowExceededNotification(Object value) {
        if (this.notifyLow) {
            this.sendNotification("jmx.monitor.gauge.low", this.derivedGaugeTimeStamp, "low threshold exceeded", this.observedAttribute, value, this.lowThreshold);
        }
    }

    void sendThresholdHighExceededNotification(Object value) {
        if (this.notifyHigh) {
            this.sendNotification("jmx.monitor.gauge.high", this.derivedGaugeTimeStamp, "high threshold exceeded", this.observedAttribute, value, this.highThreshold);
        }
    }

    void sendThresholdErrorNotification(Object value) {
        if ((this.alreadyNotified & this.THRESHOLD_ERROR_NOTIFIED) == 0) {
            this.sendNotification("jmx.monitor.error.threshold", this.derivedGaugeTimeStamp, "High or Low Threshold not the correct type", this.observedAttribute, null, null);
            this.alreadyNotified |= this.THRESHOLD_ERROR_NOTIFIED;
        }
    }
}

