/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import javax.management.MBeanAttributeInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.monitor.Monitor;
import javax.management.monitor.StringMonitorMBean;

public class StringMonitor
extends Monitor
implements StringMonitorMBean {
    int STRING_MATCHES_NOTIFIED = 16;
    int STRING_DIFFERS_NOTIFIED = 32;
    private String derivedGauge = new String();
    private long derivedGaugeTimeStamp = 0L;
    String stringToCompare = new String();
    boolean notifyMatch = false;
    boolean notifyDiffer = false;

    public StringMonitor() {
        this.dbgTag = "StringMonitor";
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        MBeanNotificationInfo[] result = new MBeanNotificationInfo[1];
        String[] types = new String[]{"jmx.monitor.error.runtime", "jmx.monitor.error.mbean", "jmx.monitor.error.attribute", "jmx.monitor.error.type", "jmx.monitor.string.matches", "jmx.monitor.string.differs"};
        result[0] = new MBeanNotificationInfo(types, "javax.management.monitor.MonitorNotification", "Notifications sent by the String Monitor Service MBean");
        return result;
    }

    public String getDerivedGauge() {
        return this.derivedGauge;
    }

    public long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimeStamp;
    }

    public String getStringToCompare() {
        return this.stringToCompare;
    }

    public void setStringToCompare(String value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("Null string to compare.");
        }
        this.stringToCompare = value;
    }

    public boolean getNotifyMatch() {
        return this.notifyMatch;
    }

    public void setNotifyMatch(boolean value) {
        this.notifyMatch = value;
    }

    public boolean getNotifyDiffer() {
        return this.notifyDiffer;
    }

    public void setNotifyDiffer(boolean value) {
        this.notifyDiffer = value;
    }

    public synchronized void start() {
        this.derivedGauge = new String();
        this.derivedGaugeTimeStamp = System.currentTimeMillis();
        super.start();
    }

    void monitor(MBeanAttributeInfo attributeInfo, Object value) throws Exception {
        if (!(value instanceof String)) {
            this.sendAttributeTypeErrorNotification("Not a string attribute");
            return;
        }
        this.derivedGauge = (String)value;
        this.derivedGaugeTimeStamp = System.currentTimeMillis();
        if (value.equals(this.stringToCompare)) {
            this.sendStringMatchesNotification((String)value);
        } else {
            this.sendStringDiffersNotification((String)value);
        }
    }

    void sendStringMatchesNotification(String value) {
        if (this.notifyMatch && (this.alreadyNotified & this.STRING_MATCHES_NOTIFIED) == 0) {
            this.sendNotification("jmx.monitor.string.matches", this.derivedGaugeTimeStamp, "matches", this.observedAttribute, value, this.stringToCompare);
            this.alreadyNotified |= this.STRING_MATCHES_NOTIFIED;
        }
        this.alreadyNotified &= ~this.STRING_DIFFERS_NOTIFIED;
    }

    void sendStringDiffersNotification(String value) {
        if (this.notifyDiffer && (this.alreadyNotified & this.STRING_DIFFERS_NOTIFIED) == 0) {
            this.sendNotification("jmx.monitor.string.differs", this.derivedGaugeTimeStamp, "differs", this.observedAttribute, value, this.stringToCompare);
            this.alreadyNotified |= this.STRING_DIFFERS_NOTIFIED;
        }
        this.alreadyNotified &= ~this.STRING_MATCHES_NOTIFIED;
    }
}

