/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

public class CompositeDataSupport
implements CompositeData,
Serializable {
    private static final long serialVersionUID = 8003518976613702244L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("contents", class$java$util$SortedMap == null ? (class$java$util$SortedMap = CompositeDataSupport.class$("java.util.SortedMap")) : class$java$util$SortedMap), new ObjectStreamField("compositeType", class$javax$management$openmbean$CompositeType == null ? (class$javax$management$openmbean$CompositeType = CompositeDataSupport.class$("javax.management.openmbean.CompositeType")) : class$javax$management$openmbean$CompositeType)};
    private SortedMap contents;
    private CompositeType compositeType;
    static /* synthetic */ Class class$java$util$SortedMap;
    static /* synthetic */ Class class$javax$management$openmbean$CompositeType;

    public CompositeDataSupport(CompositeType compositeType, String[] itemNames, Object[] itemValues) throws OpenDataException {
        if (compositeType == null) {
            throw new IllegalArgumentException("null compositeType");
        }
        if (itemNames == null) {
            throw new IllegalArgumentException("null itemNames");
        }
        if (itemValues == null) {
            throw new IllegalArgumentException("null itemValues");
        }
        if (itemNames.length == 0) {
            throw new IllegalArgumentException("empty itemNames");
        }
        if (itemValues.length == 0) {
            throw new IllegalArgumentException("empty itemValues");
        }
        if (itemNames.length != itemValues.length) {
            throw new IllegalArgumentException("itemNames has size " + itemNames.length + " but itemValues has size " + itemValues.length);
        }
        int compositeNameSize = compositeType.keySet().size();
        if (itemNames.length != compositeNameSize) {
            throw new OpenDataException("itemNames has size " + itemNames.length + " but composite type has size " + compositeNameSize);
        }
        this.compositeType = compositeType;
        this.contents = new TreeMap();
        HashSet names = new HashSet();
        int i = 0;
        while (i < itemNames.length) {
            if (itemNames[i] == null || itemNames[i].length() == 0) {
                throw new IllegalArgumentException("Item name " + i + " is null or empty");
            }
            if (names.contains(itemNames[i])) {
                throw new OpenDataException("duplicate item name " + itemNames[i]);
            }
            OpenType openType = compositeType.getType(itemNames[i]);
            if (openType == null) {
                throw new OpenDataException("item name not in composite type " + itemNames[i]);
            }
            if (itemValues[i] != null && !openType.isValue(itemValues[i])) {
                throw new OpenDataException("item value " + itemValues[i] + " for item name " + itemNames[i] + " is not a " + openType);
            }
            this.contents.put(itemNames[i], itemValues[i]);
            ++i;
        }
    }

    public CompositeDataSupport(CompositeType compositeType, Map items) throws OpenDataException {
        this.init(compositeType, items);
    }

    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    public Object get(String key) {
        this.validateKey(key);
        return this.contents.get(key);
    }

    public Object[] getAll(String[] keys) {
        if (keys == null) {
            return new Object[0];
        }
        Object[] result = new Object[keys.length];
        int i = 0;
        while (i < keys.length) {
            this.validateKey(keys[i]);
            result[i] = this.contents.get(keys[i]);
            ++i;
        }
        return result;
    }

    public boolean containsKey(String key) {
        if (key == null || key.length() == 0) {
            return false;
        }
        return this.contents.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.contents.containsValue(value);
    }

    public Collection values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = in.readFields();
        SortedMap contents = (SortedMap)getField.get("contents", null);
        CompositeType compositeType = (CompositeType)getField.get("compositeType", null);
        try {
            this.init(compositeType, contents);
        }
        catch (Exception e) {
            throw new StreamCorruptedException(e.toString());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof CompositeData)) {
            return false;
        }
        CompositeData other = (CompositeData)obj;
        if (!this.compositeType.equals(other.getCompositeType())) {
            return false;
        }
        Iterator i = this.contents.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object thisValue = this.get(key);
            Object otherValue = other.get(key);
            if (thisValue == null && otherValue != null) {
                return false;
            }
            if (thisValue.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.compositeType.hashCode();
        Iterator i = this.contents.values().iterator();
        while (i.hasNext()) {
            hash += i.next().hashCode();
        }
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": compositeType=[");
        buffer.append(this.getCompositeType());
        buffer.append("] mappings=[");
        Iterator keys = this.compositeType.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            buffer.append(key);
            buffer.append("=");
            buffer.append(this.contents.get(key));
            if (!keys.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    private void init(CompositeType compositeType, Map items) throws OpenDataException {
        if (compositeType == null) {
            throw new IllegalArgumentException("null compositeType");
        }
        if (items == null) {
            throw new IllegalArgumentException("null items");
        }
        if (items.size() == 0) {
            throw new IllegalArgumentException("empty items");
        }
        int compositeNameSize = compositeType.keySet().size();
        if (items.size() != compositeNameSize) {
            throw new OpenDataException("items has size " + items.size() + " but composite type has size " + compositeNameSize);
        }
        this.compositeType = compositeType;
        this.contents = new TreeMap();
        Iterator i = items.keySet().iterator();
        while (i.hasNext()) {
            Object next = i.next();
            if (next != null && !(next instanceof String)) {
                throw new ArrayStoreException("key is not a String " + next);
            }
            String key = (String)next;
            if (key == null || key.length() == 0) {
                throw new IllegalArgumentException("Key is null or empty");
            }
            OpenType openType = compositeType.getType(key);
            if (openType == null) {
                throw new OpenDataException("item name not in composite type " + key);
            }
            Object value = items.get(key);
            if (value != null && !openType.isValue(value)) {
                throw new OpenDataException("item value " + value + " for item name " + key + " is not a " + openType);
            }
            this.contents.put(key, value);
        }
    }

    public void validateKey(String key) throws InvalidKeyException {
        if (key == null || key.length() == 0) {
            throw new IllegalArgumentException("null or empty key");
        }
        if (!this.compositeType.containsKey(key)) {
            throw new InvalidKeyException("no such item name " + key + " for composite type " + this.compositeType);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

