/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanParameterInfo;
import javax.management.openmbean.OpenMBeanConstructorInfo;
import javax.management.openmbean.OpenMBeanParameterInfo;

public class OpenMBeanConstructorInfoSupport
extends MBeanConstructorInfo
implements OpenMBeanConstructorInfo,
Serializable {
    private static final long serialVersionUID = -4400441579007477003L;
    private transient int cachedHashCode;
    private transient String cachedToString;

    private static MBeanParameterInfo[] convertArray(OpenMBeanParameterInfo[] array) {
        if (array == null) {
            return null;
        }
        MBeanParameterInfo[] result = new MBeanParameterInfo[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    public OpenMBeanConstructorInfoSupport(String name, String description, OpenMBeanParameterInfo[] signature) {
        super(name, description, OpenMBeanConstructorInfoSupport.convertArray(signature));
        if (name == null) {
            throw new IllegalArgumentException("null name");
        }
        if (name.trim().length() == 0) {
            throw new IllegalArgumentException("empty name");
        }
        if (description == null) {
            throw new IllegalArgumentException("null description");
        }
        if (description.trim().length() == 0) {
            throw new IllegalArgumentException("empty description");
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof OpenMBeanConstructorInfoSupport)) {
            return false;
        }
        OpenMBeanConstructorInfo other = (OpenMBeanConstructorInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        return Arrays.asList(this.getSignature()).equals(Arrays.asList(other.getSignature()));
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.cachedHashCode = this.getName().hashCode();
        this.cachedHashCode += Arrays.asList(this.getSignature()).hashCode();
        return this.cachedHashCode;
    }

    public String toString() {
        if (this.cachedToString != null) {
            return this.cachedToString;
        }
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        buffer.append(": name=");
        buffer.append(this.getName());
        buffer.append(", signature=");
        buffer.append(Arrays.asList(this.getSignature()));
        this.cachedToString = buffer.toString();
        return this.cachedToString;
    }
}

