/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.Notification;
import javax.management.ObjectName;

public class RelationNotification
extends Notification
implements Serializable {
    public static String RELATION_BASIC_CREATION = "jmx.relation.creation.basic";
    public static String RELATION_BASIC_REMOVAL = "jmx.relation.removal.basic";
    public static String RELATION_BASIC_UPDATE = "jmx.relation.update.basic";
    public static String RELATION_MBEAN_CREATION = "jmx.relation.creation.mbean";
    public static String RELATION_MBEAN_REMOVAL = "jmx.relation.removal.mbean";
    public static String RELATION_MBEAN_UPDATE = "jmx.relation.update.mbean";
    private static int CREATION_REMOVAL = 0;
    private static int UPDATE = 1;
    private ArrayList unregMBeans;
    private ArrayList newRoleValue;
    private ObjectName relObjName;
    private ArrayList oldRoleValue;
    private String relTypeId;
    private String relTypeName;
    private String roleName;

    public RelationNotification(String type, Object source, long sequenceNumber, long timeStamp, String message, String relTypeId, String relTypeName, ObjectName relObjName, List unregMBeans) throws IllegalArgumentException {
        super(type, source, sequenceNumber, timeStamp, message);
        this.init(CREATION_REMOVAL, type, source, sequenceNumber, timeStamp, message, relTypeId, relTypeName, relObjName, unregMBeans, null, null, null);
    }

    public RelationNotification(String type, Object source, long sequenceNumber, long timeStamp, String message, String relTypeId, String relTypeName, ObjectName relObjName, String roleName, List newRoleValue, List oldRoleValue) throws IllegalArgumentException {
        super(type, source, sequenceNumber, timeStamp, message);
        this.init(UPDATE, type, source, sequenceNumber, timeStamp, message, relTypeId, relTypeName, relObjName, null, roleName, newRoleValue, oldRoleValue);
    }

    public List getMBeansToUnregister() {
        if (this.unregMBeans == null) {
            return new ArrayList();
        }
        return new ArrayList(this.unregMBeans);
    }

    public List getNewRoleValue() {
        if (this.newRoleValue == null) {
            return new ArrayList();
        }
        return new ArrayList(this.newRoleValue);
    }

    public ObjectName getObjectName() {
        return this.relObjName;
    }

    public List getOldRoleValue() {
        if (this.oldRoleValue == null) {
            return new ArrayList();
        }
        return new ArrayList(this.oldRoleValue);
    }

    public String getRelationId() {
        return this.relTypeId;
    }

    public String getRelationTypeName() {
        return this.relTypeName;
    }

    public String getRoleName() {
        return this.roleName;
    }

    private void init(int which, String type, Object source, long sequenceNumber, long timeStamp, String message, String relTypeId, String relTypeName, ObjectName relObjName, List unregMBeans, String roleName, List newRoleValue, List oldRoleValue) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("null notification type");
        }
        if (which == CREATION_REMOVAL && type != RELATION_BASIC_CREATION && type != RELATION_BASIC_REMOVAL && type != RELATION_MBEAN_CREATION && type != RELATION_MBEAN_REMOVAL) {
            throw new IllegalArgumentException("Invalid creation/removal notifcation");
        }
        if (which == UPDATE && type != RELATION_BASIC_UPDATE && type != RELATION_MBEAN_UPDATE) {
            throw new IllegalArgumentException("Invalid update notifcation");
        }
        if (type == null) {
            throw new IllegalArgumentException("null source");
        }
        if (relTypeId == null) {
            throw new IllegalArgumentException("null relation id");
        }
        if (relTypeName == null) {
            throw new IllegalArgumentException("null relation type name");
        }
        if (which == UPDATE && roleName == null) {
            throw new IllegalArgumentException("null role name");
        }
        if (which == UPDATE && newRoleValue == null) {
            throw new IllegalArgumentException("null new role value");
        }
        if (which == UPDATE && oldRoleValue == null) {
            throw new IllegalArgumentException("null old role value");
        }
        this.relTypeId = relTypeId;
        this.relTypeName = relTypeName;
        this.relObjName = relObjName;
        if (unregMBeans != null) {
            this.unregMBeans = new ArrayList(unregMBeans);
        }
        if (roleName != null) {
            this.roleName = roleName;
        }
        if (newRoleValue != null) {
            this.newRoleValue = new ArrayList(newRoleValue);
        }
        if (oldRoleValue != null) {
            this.oldRoleValue = new ArrayList(oldRoleValue);
        }
    }
}

