/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.RelationType;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;

public class RelationTypeSupport
implements RelationType {
    private String name;
    private ArrayList roleInfos;

    protected RelationTypeSupport(String name) {
        this.name = name;
        this.roleInfos = new ArrayList();
    }

    public RelationTypeSupport(String name, RoleInfo[] infos) throws IllegalArgumentException, InvalidRelationTypeException {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        if (infos == null) {
            throw new IllegalArgumentException("No role information");
        }
        if (infos.length == 0) {
            throw new InvalidRelationTypeException("No role information");
        }
        this.name = name;
        HashSet<String> roleNames = new HashSet<String>();
        this.roleInfos = new ArrayList(infos.length);
        int i = 0;
        while (i < infos.length) {
            if (infos[i] == null) {
                throw new InvalidRelationTypeException("Null role");
            }
            if (roleNames.contains(infos[i].getName())) {
                throw new InvalidRelationTypeException("Duplicate role name" + infos[i].getName());
            }
            roleNames.add(infos[i].getName());
            this.roleInfos.add(infos[i]);
            ++i;
        }
    }

    public String getRelationTypeName() {
        return this.name;
    }

    public List getRoleInfos() {
        return this.roleInfos;
    }

    public RoleInfo getRoleInfo(String roleInfoName) throws RoleInfoNotFoundException {
        if (roleInfoName == null) {
            throw new IllegalArgumentException("Null role info name");
        }
        RoleInfo result = null;
        ArrayList temp = new ArrayList(this.roleInfos);
        Iterator iterator = temp.iterator();
        while (iterator.hasNext()) {
            RoleInfo info = (RoleInfo)iterator.next();
            if (!info.getName().equals(roleInfoName)) continue;
            result = info;
            break;
        }
        if (result == null) {
            throw new RoleInfoNotFoundException(roleInfoName);
        }
        return result;
    }

    protected void addRoleInfo(RoleInfo roleInfo) throws IllegalArgumentException, InvalidRelationTypeException {
        if (roleInfo == null) {
            throw new IllegalArgumentException("No role information");
        }
        String newName = roleInfo.getName();
        ArrayList arrayList = this.roleInfos;
        synchronized (arrayList) {
            Iterator iterator = this.roleInfos.iterator();
            while (iterator.hasNext()) {
                RoleInfo info = (RoleInfo)iterator.next();
                if (!info.getName().equals(newName)) continue;
                throw new InvalidRelationTypeException("Duplicate role name");
            }
            this.roleInfos.add(roleInfo);
        }
    }
}

