/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.management.relation.RoleStatus;

public class RoleUnresolved
implements Serializable {
    private String name;
    private ArrayList value;
    private int problem;

    public RoleUnresolved(String roleName, List roleValue, int problemType) throws IllegalArgumentException {
        if (roleName == null) {
            throw new IllegalArgumentException("Null roleName");
        }
        if (roleValue == null) {
            throw new IllegalArgumentException("Null roleValue");
        }
        if (!RoleStatus.isRoleStatus(problemType)) {
            throw new IllegalArgumentException("Invalid problem type.");
        }
        this.name = roleName;
        this.value = (ArrayList)roleValue;
        this.problem = problemType;
    }

    public int getProblemType() {
        return this.problem;
    }

    public String getRoleName() {
        return this.name;
    }

    public List getRoleValue() {
        return this.value;
    }

    public void setProblemType(int problemType) throws IllegalArgumentException {
        if (!RoleStatus.isRoleStatus(problemType)) {
            throw new IllegalArgumentException("Invalid problem type.");
        }
        this.problem = problemType;
    }

    public void setRoleName(String roleName) throws IllegalArgumentException {
        if (roleName == null) {
            throw new IllegalArgumentException("Null roleName");
        }
        this.name = roleName;
    }

    public void setRoleValue(List roleValue) {
        this.value = (ArrayList)roleValue;
    }

    public Object clone() {
        return new RoleUnresolved(this.name, new ArrayList(this.value), this.problem);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Problem (");
        buffer.append(this.problem);
        buffer.append(") Role Name (");
        buffer.append(this.name);
        buffer.append(") ObjectNames (");
        Iterator iterator = new ArrayList(this.value).iterator();
        while (iterator.hasNext()) {
            buffer.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buffer.append(" ");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

