/*
 * Decompiled with CFR 0.152.
 */
package javax.management.timer;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.management.timer.TimerMBean;
import javax.management.timer.TimerNotification;
import org.jboss.mx.util.RunnableScheduler;
import org.jboss.mx.util.SchedulableRunnable;

public class Timer
extends NotificationBroadcasterSupport
implements TimerMBean,
MBeanRegistration,
Serializable {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;
    private static final int SEND_NO = 0;
    private static final int SEND_START = 1;
    private static final int SEND_NORMAL = 2;
    int nextId = 0;
    long sequenceNumber = 0L;
    boolean sendPastNotifications = false;
    boolean active = false;
    ObjectName objectName;
    HashMap notifications = new HashMap();
    private RunnableScheduler scheduler = new RunnableScheduler();

    public Integer addNotification(String type, String message, Object userData, Date date) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period) throws IllegalArgumentException {
        return this.addNotification(type, message, userData, date, period, 0L);
    }

    public Integer addNotification(String type, String message, Object userData, Date date, long period, long occurences) throws IllegalArgumentException {
        int newId = 0;
        newId = ++this.nextId;
        Integer id = new Integer(newId);
        RegisteredNotification rn = new RegisteredNotification(id, type, message, userData, date, period, occurences);
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            this.notifications.put(id, rn);
            rn.setNextRun(rn.nextDate);
            rn.setScheduler(this.scheduler);
        }
        return id;
    }

    public Vector getAllNotificationIDs() {
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Vector vector = new Vector(this.notifications.keySet());
            return vector;
        }
    }

    public Date getDate(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
        if (rn == null) {
            return null;
        }
        return new Date(rn.startDate);
    }

    public int getNbNotifications() {
        return this.notifications.size();
    }

    public Long getNbOccurences(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
        if (rn == null) {
            return null;
        }
        return new Long(rn.occurences);
    }

    public Vector getNotificationIDs(String type) {
        Vector<Integer> result = new Vector<Integer>();
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Iterator iterator = this.notifications.values().iterator();
            while (iterator.hasNext()) {
                RegisteredNotification rn = (RegisteredNotification)iterator.next();
                if (!rn.type.equals(type)) continue;
                result.add(rn.id);
            }
        }
        return result;
    }

    public String getNotificationMessage(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
        if (rn == null) {
            return null;
        }
        return rn.message;
    }

    public String getNotificationType(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
        if (rn == null) {
            return null;
        }
        return rn.type;
    }

    public Object getNotificationUserData(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
        if (rn == null) {
            return null;
        }
        return rn.userData;
    }

    public Long getPeriod(Integer id) {
        RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
        if (rn == null) {
            return null;
        }
        return new Long(rn.period);
    }

    public boolean getSendPastNotifications() {
        return this.sendPastNotifications;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isEmpty() {
        return this.notifications.isEmpty();
    }

    public void removeAllNotifications() {
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Iterator iterator = this.notifications.values().iterator();
            while (iterator.hasNext()) {
                RegisteredNotification rn = (RegisteredNotification)iterator.next();
                rn.setScheduler(null);
                iterator.remove();
            }
        }
        Timer timer = this;
        synchronized (timer) {
            this.nextId = 0;
        }
    }

    public void removeNotification(Integer id) throws InstanceNotFoundException {
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            RegisteredNotification rn = (RegisteredNotification)this.notifications.get(id);
            if (rn == null) {
                throw new InstanceNotFoundException("No notification id : " + id.toString());
            }
            rn.setScheduler(null);
            this.notifications.remove(id);
        }
    }

    public void removeNotifications(String type) throws InstanceNotFoundException {
        boolean found = false;
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Iterator iterator = this.notifications.values().iterator();
            while (iterator.hasNext()) {
                RegisteredNotification rn = (RegisteredNotification)iterator.next();
                if (!rn.type.equals(type)) continue;
                rn.setScheduler(null);
                iterator.remove();
                found = true;
            }
        }
        if (!found) {
            throw new InstanceNotFoundException("Nothing registered for type: " + type);
        }
    }

    public void setSendPastNotifications(boolean value) {
        this.sendPastNotifications = value;
    }

    public synchronized void start() {
        if (this.active) {
            return;
        }
        this.active = true;
        HashMap hashMap = this.notifications;
        synchronized (hashMap) {
            Iterator iterator = this.notifications.values().iterator();
            while (iterator.hasNext()) {
                RegisteredNotification rn = (RegisteredNotification)iterator.next();
                rn.sendType = this.sendPastNotifications ? 1 : 0;
                this.sendNotifications(rn);
                rn.sendType = 2;
            }
        }
        this.scheduler.start();
    }

    public synchronized void stop() {
        if (!this.active) {
            return;
        }
        this.active = false;
        this.scheduler.stop();
    }

    public ObjectName preRegister(MBeanServer server, ObjectName objectName) throws Exception {
        this.objectName = objectName;
        return objectName;
    }

    public void postRegister(Boolean registrationDone) {
    }

    public void preDeregister() throws Exception {
        this.stop();
    }

    public void postDeregister() {
    }

    private void sendNotifications(RegisteredNotification rn) {
        while (this.isActive() && rn.nextDate != 0L && rn.nextDate <= System.currentTimeMillis()) {
            if (rn.sendType != 0) {
                long seq = 0L;
                Timer timer = this;
                synchronized (timer) {
                    seq = ++this.sequenceNumber;
                }
                this.sendNotification(new TimerNotification(rn.type, this.objectName, seq, rn.nextDate, rn.message, rn.id, rn.userData));
            }
            do {
                if (rn.calcNextDate()) continue;
                HashMap hashMap = this.notifications;
                synchronized (hashMap) {
                    this.notifications.remove(rn.id);
                }
            } while (this.isActive() && rn.sendType != 1 && rn.nextDate != 0L && rn.occurences == 0L && rn.nextDate < System.currentTimeMillis());
        }
        if (rn.nextDate != 0L) {
            rn.setNextRun(rn.nextDate);
        }
    }

    private class RegisteredNotification
    extends SchedulableRunnable {
        public Integer id;
        public String type;
        public String message;
        public Object userData;
        public long startDate;
        public long period;
        public long occurences;
        public int sendType = 2;
        public long nextDate = 0L;

        public RegisteredNotification(Integer id, String type, String message, Object userData, Date startDate, long period, long occurences) throws IllegalArgumentException {
            if (startDate == null) {
                throw new IllegalArgumentException("Null Date");
            }
            if (period < 0L) {
                throw new IllegalArgumentException("Negative Period");
            }
            if (occurences < 0L) {
                throw new IllegalArgumentException("Negative Occurences");
            }
            this.id = id;
            this.type = type;
            this.message = message;
            this.userData = userData;
            this.startDate = startDate.getTime();
            this.period = period;
            this.occurences = occurences;
            this.nextDate = this.startDate;
            while (this.nextDate < System.currentTimeMillis()) {
                if (this.calcNextDate()) continue;
                throw new IllegalArgumentException("Requested notification(s) in the past.");
            }
        }

        boolean calcNextDate() {
            if (this.period == 0L) {
                this.nextDate = 0L;
                return false;
            }
            if (this.occurences != 0L && --this.occurences == 0L) {
                this.nextDate = 0L;
                return false;
            }
            this.nextDate += this.period;
            return true;
        }

        public void doRun() {
            Timer.this.sendNotifications(this);
        }
    }
}

