/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.capability;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.NotificationBroadcaster;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import org.jboss.mx.metadata.AttributeOperationResolver;

public class ReflectedMBeanDispatcher
implements DynamicMBean {
    private Object resource = null;
    private AttributeOperationResolver resolver = null;
    private MBeanConstructorInfo[] constructorInfo = null;
    private MBeanAttributeInfo[] attributeInfo = null;
    private MBeanOperationInfo[] operationInfo = null;
    private Method[] operations = null;
    private MethodPair[] attributes = null;
    private boolean isBroadcaster = false;
    private String resourceClassName = null;
    private String resourceDescription = null;

    public ReflectedMBeanDispatcher(MBeanInfo mbinfo, AttributeOperationResolver resolver, Object resource) {
        if (null == resource) {
            throw new IllegalArgumentException("resource cannot be null");
        }
        if (null == mbinfo) {
            throw new IllegalArgumentException("MBeanInfo cannot be null");
        }
        if (null == resolver) {
            throw new IllegalArgumentException("AOresolver cannot be null");
        }
        if (resource instanceof NotificationBroadcaster) {
            this.isBroadcaster = true;
        }
        this.resource = resource;
        this.resolver = resolver;
        this.resourceClassName = mbinfo.getClassName();
        this.resourceDescription = mbinfo.getDescription();
        this.constructorInfo = mbinfo.getConstructors();
        this.attributeInfo = mbinfo.getAttributes();
        this.operationInfo = mbinfo.getOperations();
        this.operations = new Method[this.operationInfo.length];
        this.attributes = new MethodPair[this.attributeInfo.length];
    }

    public void bindOperationAt(int position, Method method) {
        try {
            this.operations[position] = method;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("position out of bounds: " + position);
        }
    }

    public void bindAttributeAt(int position, Method getter, Method setter) {
        try {
            this.attributes[position] = new MethodPair(getter, setter);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("position out of bounds: " + position);
        }
    }

    public String getResourceClassName() {
        return this.resourceClassName;
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (null == attribute) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute cannot be null"));
        }
        Method m = null;
        try {
            m = this.attributes[this.resolver.lookup((String)attribute).intValue()].getter;
            return m.invoke(this.resource, new Object[0]);
        }
        catch (NullPointerException e) {
            throw new AttributeNotFoundException("Readable attribute '" + attribute + "' not found");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AttributeNotFoundException("Readable attribute '" + attribute + "' not found");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException in MBean when getting attribute '" + attribute + "'");
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t, "Exception in MBean when getting attribute '" + attribute + "'");
            }
            throw new RuntimeErrorException((Error)t, "Error in MBean when getting attribute '" + attribute + "'");
        }
        catch (IllegalArgumentException e) {
            throw new AttributeNotFoundException("Readable attribute '" + attribute + "' not found");
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Exception in AttributeProvider for getting '" + attribute + "'");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error in AttributeProvider for getting '" + attribute + "'");
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (null == attribute) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute cannot be null"));
        }
        Method m = null;
        try {
            m = this.attributes[this.resolver.lookup((String)attribute.getName()).intValue()].setter;
            m.invoke(this.resource, attribute.getValue());
        }
        catch (NullPointerException e) {
            throw new AttributeNotFoundException("Writable attribute '" + attribute.getName() + "' not found");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new AttributeNotFoundException("Writable attribute '" + attribute.getName() + "' not found");
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException in MBean when setting attribute '" + attribute.getName() + "'");
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t, "Exception in MBean when setting attribute '" + attribute.getName() + "'");
            }
            throw new RuntimeErrorException((Error)t, "Error in MBean when setting attribute '" + attribute.getName() + "'");
        }
        catch (IllegalArgumentException e) {
            String valueType = null == attribute.getValue() ? "<null value>" : attribute.getValue().getClass().getName();
            throw new InvalidAttributeValueException("Attribute value mismatch while setting '" + attribute.getName() + "': " + valueType);
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Exception in AttributeProvider for setting '" + attribute.getName() + "'");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error in AttributeProvider for setting '" + attribute.getName() + "'");
        }
    }

    public AttributeList getAttributes(String[] attributes) {
        if (null == attributes) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes array cannot be null"));
        }
        AttributeList list = new AttributeList();
        int i = 0;
        while (i < attributes.length) {
            try {
                list.add(new Attribute(attributes[i], this.getAttribute(attributes[i])));
            }
            catch (Throwable e) {
                // empty catch block
            }
            ++i;
        }
        return list;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (null == attributes) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute list cannot be null"));
        }
        AttributeList list = new AttributeList();
        Iterator iterator = attributes.iterator();
        while (iterator.hasNext()) {
            Attribute toSet = (Attribute)iterator.next();
            try {
                this.setAttribute(toSet);
                list.add(toSet);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        return list;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        Method m = null;
        try {
            m = this.operations[this.resolver.lookup(actionName, signature)];
            return m.invoke(this.resource, params);
        }
        catch (NullPointerException e) {
            throw new ReflectionException(new NoSuchMethodException("Unable to locate method for: " + this.opKeyString(actionName, signature)));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ReflectionException(new NoSuchMethodException("Unable to locate method for: " + this.opKeyString(actionName, signature)));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw new RuntimeMBeanException((RuntimeException)t, "RuntimeException in MBean operation '" + this.opKeyString(actionName, signature) + "'");
            }
            if (t instanceof Exception) {
                throw new MBeanException((Exception)t, "Exception in MBean operation '" + this.opKeyString(actionName, signature) + "'");
            }
            throw new RuntimeErrorException((Error)t, "Error in MBean operation '" + this.opKeyString(actionName, signature) + "'");
        }
        catch (Exception e) {
            throw new ReflectionException(e, "Exception when calling method for '" + this.opKeyString(actionName, signature) + "'");
        }
        catch (Error e) {
            throw new RuntimeErrorException(e, "Error when calling method for '" + this.opKeyString(actionName, signature) + "'");
        }
    }

    public MBeanInfo getMBeanInfo() {
        return new MBeanInfo(this.resourceClassName, this.resourceDescription, this.attributeInfo, this.constructorInfo, this.operationInfo, this.isBroadcaster ? this.getNotificationInfo() : new MBeanNotificationInfo[]{});
    }

    protected MBeanNotificationInfo[] getNotificationInfo() {
        if (this.isBroadcaster) {
            return ((NotificationBroadcaster)this.resource).getNotificationInfo();
        }
        throw new RuntimeOperationsException(new UnsupportedOperationException("resource is not a NotificationBroadcaster"));
    }

    protected Object getResourceObject() {
        return this.resource;
    }

    protected final String opKeyString(String name, String[] signature) {
        StringBuffer buf = new StringBuffer(name).append('(');
        if (null != signature) {
            int i = 0;
            while (i < signature.length) {
                buf.append(',').append(signature[i]);
                ++i;
            }
        }
        return buf.append(')').toString();
    }

    public static class MethodPair {
        public Method getter = null;
        public Method setter = null;

        public MethodPair(Method getter, Method setter) {
            this.getter = getter;
            this.setter = setter;
        }
    }
}

