/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import javax.management.Attribute;
import javax.management.Descriptor;
import javax.management.modelmbean.ModelMBeanInfo;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.modelmbean.ModelBase;
import org.jboss.mx.modelmbean.ModelMBeanConstants;
import org.jboss.mx.server.MBeanInvoker;

public class MBeanAttributeInterceptor
extends Interceptor
implements ModelMBeanConstants {
    private ModelMBeanInfo info = null;
    private MBeanInvoker invoker = null;

    public MBeanAttributeInterceptor(ModelMBeanInfo info, MBeanInvoker invoker) {
        super("MBean Attribute Interceptor");
        this.info = info;
        this.invoker = invoker;
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        if (invocation.getInvocationType() == 16) {
            return this.getNext().invoke(invocation);
        }
        try {
            String attrName = invocation.getName();
            Descriptor d = this.info.getDescriptor(attrName, "attribute");
            if (invocation.getImpact() == 2) {
                String timeLimit;
                long limit;
                Object value = invocation.getArgs()[0];
                Object oldValue = d.getFieldValue("value");
                String setMethod = (String)d.getFieldValue("setMethod");
                if (setMethod != null) {
                    this.invoker.invoke(setMethod, new Object[]{value}, invocation.getSignature());
                }
                long l = limit = (timeLimit = (String)d.getFieldValue("currencyTimeLimit")) == null ? 0L : Long.parseLong(timeLimit);
                if (limit != 0L) {
                    d.setField("value", value);
                    d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
                    this.info.setDescriptor(d, "attribute");
                }
                ((ModelBase)this.invoker).sendAttributeChangeNotification(new Attribute(attrName, oldValue), new Attribute(attrName, value));
            } else {
                String getMethod = (String)d.getFieldValue("getMethod");
                if (getMethod != null) {
                    long limit;
                    String timeLimit = (String)d.getFieldValue("currencyTimeLimit");
                    long l = limit = timeLimit == null ? 0L : Long.parseLong(timeLimit);
                    if (limit == -1L) {
                        return d.getFieldValue("value");
                    }
                    if (limit > 0L) {
                        long lastUpdate;
                        String timeStamp = (String)d.getFieldValue("lastUpdatedTimeStamp");
                        long l2 = lastUpdate = timeStamp == null ? 0L : Long.parseLong(timeStamp);
                        if (System.currentTimeMillis() < lastUpdate * 1000L + limit * 1000L) {
                            return d.getFieldValue("value");
                        }
                    }
                    Object value = this.invoker.invoke(getMethod, new Object[0], new String[0]);
                    d.setField("value", value);
                    d.setField("lastUpdatedTimeStamp", "" + System.currentTimeMillis() / 1000L);
                    this.info.setDescriptor(d, "attribute");
                }
            }
            return d.getFieldValue("value");
        }
        catch (Throwable t) {
            throw new InvocationException(t);
        }
    }
}

