/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.mx.interceptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;
import javax.management.modelmbean.ModelMBeanInfo;
import org.jboss.mx.interceptor.Interceptor;
import org.jboss.mx.interceptor.Invocation;
import org.jboss.mx.interceptor.InvocationException;
import org.jboss.mx.interceptor.StandardMBeanInterceptor;

public class ModelMBeanInterceptor
extends Interceptor {
    private Map methodMap = new HashMap();
    private MBeanInfo info;
    private Object resource;

    public ModelMBeanInterceptor(Object resource, ModelMBeanInfo info) throws ReflectionException {
        super("Model MBean Interceptor");
        this.resource = resource;
        MBeanOperationInfo[] operations = info.getOperations();
        int i = 0;
        while (i < operations.length) {
            try {
                String name = operations[i].getName();
                MBeanParameterInfo[] params = operations[i].getSignature();
                StringBuffer strBuf = new StringBuffer(500);
                int j = 0;
                while (j < params.length) {
                    strBuf.append(params[j].getType());
                    ++j;
                }
                this.methodMap.put(name + strBuf.toString(), resource.getClass().getMethod(name, StandardMBeanInterceptor.getSignatureAsClassArray(params, resource.getClass().getClassLoader())));
            }
            catch (ClassNotFoundException e) {
                throw new ReflectionException(e, "Unable to load operation " + operations[i].getName() + " parameter types: " + e.getMessage());
            }
            catch (NoSuchMethodException e) {
                throw new ReflectionException(e);
            }
            ++i;
        }
    }

    public Object invoke(Invocation invocation) throws InvocationException {
        try {
            Method m = (Method)this.methodMap.get(invocation.getOperationWithSignature());
            return m.invoke(this.resource, invocation.getArgs());
        }
        catch (IllegalAccessException e) {
            throw new InvocationException(e, "Illegal access to method " + invocation.getName());
        }
        catch (IllegalArgumentException e) {
            throw new InvocationException(e, "Illegal operation arguments in " + invocation.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof Exception) {
                Exception e2 = (Exception)e.getTargetException();
                throw new InvocationException(e2, "Operation " + invocation.getName() + " on MBean " + this.info.getClassName() + " has thrown an exception: " + e2.toString());
            }
            Error err = (Error)e.getTargetException();
            throw new InvocationException(err, "Operation " + invocation.getName() + " on MBean " + this.info.getClassName() + " has thrown an errpr: " + err.toString());
        }
        catch (NullPointerException e) {
            throw new InvocationException(e, "Operation " + invocation.getName() + " is not a declared management operation.");
        }
    }
}

